/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.XNet;
import mcjty.xnet.apiimpl.Constants;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.apiimpl.items.ItemFilterCache;
import mcjty.xnet.apiimpl.items.enums.ExtractMode;
import mcjty.xnet.apiimpl.items.enums.StackMode;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"textures/gui/guielements.png");
    public static final int FILTER_SIZE = 18;
    private InsExtMode itemMode = InsExtMode.INS;
    private ExtractMode extractMode = ExtractMode.FIRST;
    private int speed = 2;
    private StackMode stackMode = StackMode.SINGLE;
    private boolean tagsMode = false;
    private boolean metaMode = false;
    private boolean componentMode = false;
    private boolean blacklist = false;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer count = null;
    @Nullable
    private Integer extractAmount = null;
    private final ItemStackList filters = ItemStackList.create((int)18);
    private int filterIndex = -1;
    public static final MapCodec<ItemConnectorSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbstractConnectorSettings.BaseSettings.CODEC.fieldOf("base").forGetter(settings -> settings.settings), (App)InsExtMode.CODEC.fieldOf("itemMode").forGetter(settings -> settings.itemMode), (App)ExtractMode.CODEC.fieldOf("extractMode").forGetter(settings -> settings.extractMode), (App)StackMode.CODEC.fieldOf("stackMode").forGetter(settings -> settings.stackMode), (App)Codec.INT.fieldOf("speed").forGetter(settings -> settings.speed), (App)Codec.INT.fieldOf("filterIndex").forGetter(settings -> settings.filterIndex), (App)Codec.BOOL.fieldOf("tagsMode").forGetter(settings -> settings.tagsMode), (App)Codec.BOOL.fieldOf("metaMode").forGetter(settings -> settings.metaMode), (App)Codec.BOOL.fieldOf("componentMode").forGetter(settings -> settings.componentMode), (App)Codec.BOOL.fieldOf("blacklist").forGetter(settings -> settings.blacklist), (App)Codec.INT.optionalFieldOf("priority").forGetter(settings -> Optional.ofNullable(settings.priority)), (App)Codec.INT.optionalFieldOf("extractAmount").forGetter(settings -> Optional.ofNullable(settings.extractAmount)), (App)Codec.INT.optionalFieldOf("count").forGetter(settings -> Optional.ofNullable(settings.count)), (App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("filters").forGetter(settings -> settings.filters)).apply((Applicative)instance, (base, itemMode, extractMode, stackMode, speed, filterIndex, tagsMode, metaMode, componentMode, blacklist, priority, extractAmount, count, filters) -> {
        ItemConnectorSettings settings = new ItemConnectorSettings((AbstractConnectorSettings.BaseSettings)base, Direction.NORTH);
        settings.itemMode = itemMode;
        settings.extractMode = extractMode;
        settings.stackMode = stackMode;
        settings.speed = speed;
        settings.filterIndex = filterIndex;
        settings.tagsMode = tagsMode;
        settings.metaMode = metaMode;
        settings.componentMode = componentMode;
        settings.blacklist = blacklist;
        settings.priority = priority.orElse(null);
        settings.extractAmount = extractAmount.orElse(null);
        settings.count = count.orElse(null);
        for (int i = 0; i < 18; ++i) {
            settings.filters.set(i, (Object)((ItemStack)filters.get(i)));
        }
        return settings;
    }));
    public static StreamCodec<RegistryFriendlyByteBuf, ItemConnectorSettings> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)AbstractConnectorSettings.BaseSettings.STREAM_CODEC, s -> s.settings, InsExtMode.STREAM_CODEC, s -> s.itemMode, ExtractMode.STREAM_CODEC, s -> s.extractMode, StackMode.STREAM_CODEC, s -> s.stackMode, (StreamCodec)ByteBufCodecs.INT, s -> s.speed, (StreamCodec)ByteBufCodecs.INT, s -> s.filterIndex, (StreamCodec)ByteBufCodecs.BOOL, s -> s.tagsMode, (StreamCodec)ByteBufCodecs.BOOL, s -> s.metaMode, (StreamCodec)ByteBufCodecs.BOOL, s -> s.componentMode, (StreamCodec)ByteBufCodecs.BOOL, s -> s.blacklist, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.priority), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.extractAmount), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.count), (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, s -> s.filters, (base, itemMode, extractMode, stackMode, speed, filterIndex, tagsMode, metaMode, componentMode, blacklist, priority, extractAmount, count, filters) -> {
        ItemConnectorSettings settings = new ItemConnectorSettings((AbstractConnectorSettings.BaseSettings)base, Direction.NORTH);
        settings.itemMode = itemMode;
        settings.extractMode = extractMode;
        settings.stackMode = stackMode;
        settings.speed = speed;
        settings.filterIndex = filterIndex;
        settings.tagsMode = tagsMode;
        settings.metaMode = metaMode;
        settings.componentMode = componentMode;
        settings.blacklist = blacklist;
        settings.priority = priority.orElse(null);
        settings.extractAmount = extractAmount.orElse(null);
        settings.count = count.orElse(null);
        for (int i = 0; i < 18; ++i) {
            settings.filters.set(i, (Object)((ItemStack)filters.get(i)));
        }
        return settings;
    });
    private Predicate<ItemStack> matcher = null;
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "priority", "od", "meta", "nbt", "blacklist"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "od", "meta", "nbt", "blacklist", "stack", "speed", "extract", "extractAmount"});

    public ItemConnectorSettings(@Nonnull AbstractConnectorSettings.BaseSettings settings, @Nonnull Direction side) {
        super(settings, side);
    }

    public InsExtMode getItemMode() {
        return this.itemMode;
    }

    public IChannelType getType() {
        return XNet.setup.itemChannelType;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.itemMode) {
            default -> throw new MatchException(null, null);
            case InsExtMode.INS -> new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            case InsExtMode.EXT -> new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    private String getMinMaxTooltip() {
        return I18nConstants.ITEM_COUNT_TOOLTIP_FORMATTED.i18n((this.itemMode == InsExtMode.EXT ? I18nConstants.EXT_ENDING : I18nConstants.INS_ENDING).i18n(new Object[0]), (this.itemMode == InsExtMode.EXT ? I18nConstants.LOW_FORMAT : I18nConstants.HIGH_FORMAT).i18n(new Object[0]));
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? Constants.ADVANCED_SPEEDS : Constants.SPEEDS;
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl();
        gui.translatableChoices("mode", (ITranslatableEnum)this.itemMode, (ITranslatableEnum[])InsExtMode.values()).shift(5);
        gui.translatableChoices("stack", (ITranslatableEnum)this.stackMode, (ITranslatableEnum[])StackMode.values());
        if (this.stackMode == StackMode.COUNT && this.itemMode == InsExtMode.EXT) {
            gui.integer("extractAmount", I18nConstants.ITEM_EXT_COUNT_TOOLTIP.i18n(new Object[0]), this.extractAmount, 30, Integer.valueOf(64));
        }
        gui.shift(10).choices("speed", I18nConstants.SPEED_TOOLTIP.i18n(new Object[0]), Integer.toString(this.speed * 5), speeds);
        gui.nl();
        gui.label(I18nConstants.PRIORITY_LABEL.i18n(new Object[0])).integer("priority", I18nConstants.PRIORITY_TOOLTIP.i18n(new Object[0]), this.priority, 36).shift(5).label("#").integer("count", this.getMinMaxTooltip(), this.count, 30);
        if (this.itemMode == InsExtMode.EXT) {
            gui.shift(5).translatableChoices("extract", (ITranslatableEnum)this.extractMode, (ITranslatableEnum[])ExtractMode.values());
        }
        gui.nl();
        gui.toggleText("blacklist", I18nConstants.ITEM_BLACKLIST_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_BLACKLIST_LABEL.i18n(new Object[0]), this.blacklist).shift(0).toggleText("od", I18nConstants.ITEM_TAGS_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_TAGS_LABEL.i18n(new Object[0]), this.tagsMode).shift(0).toggleText("meta", I18nConstants.ITEM_META_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_META_LABEL.i18n(new Object[0]), this.metaMode).shift(0).toggleText("nbt", I18nConstants.ITEM_NBT_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_NBT_LABEL.i18n(new Object[0]), this.componentMode).shift(0).choices("fltIdx", I18nConstants.ITEM_FILTER_INDEX_TOOLTIP.i18n(new Object[0]), this.getFilterIndexString(), new String[]{I18nConstants.ITEM_FILTER_OFF.i18n(new Object[0]), "1", "2", "3", "4"}).nl();
        for (int i = 0; i < 18; ++i) {
            if (i > 0 && i % 9 == 0) {
                gui.nl();
            }
            gui.ghostSlot("flt" + i, (ItemStack)this.filters.get(i));
        }
    }

    private String getFilterIndexString() {
        if (this.filterIndex == -1) {
            return I18nConstants.ITEM_FILTER_OFF.i18n(new Object[0]);
        }
        return Integer.toString(this.filterIndex);
    }

    public Predicate<ItemStack> getMatcher(IControllerContext context) {
        if (this.matcher == null) {
            ItemStackList filterList = ItemStackList.create();
            for (ItemStack stack2 : this.filters) {
                if (stack2.isEmpty()) continue;
                filterList.add((Object)stack2);
            }
            Predicate<ItemStack> filterMatcher = this.getIndexFilterMatcher(context);
            if (filterList.isEmpty()) {
                this.matcher = filterMatcher != null ? filterMatcher : itemStack -> true;
            } else {
                ItemFilterCache filterCache = new ItemFilterCache(this.metaMode, this.tagsMode, this.blacklist, this.componentMode, filterList);
                this.matcher = filterMatcher != null ? stack -> filterMatcher.test((ItemStack)stack) || filterCache.match((ItemStack)stack) : filterCache::match;
            }
        }
        return this.matcher;
    }

    @Nullable
    private Predicate<ItemStack> getIndexFilterMatcher(IControllerContext context) {
        if (this.filterIndex == -1) {
            return null;
        }
        return s -> context.getIndexedFilter(this.filterIndex - 1).test(s);
    }

    public StackMode getStackMode() {
        return this.stackMode;
    }

    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getCount() {
        return this.count;
    }

    public int getExtractAmount() {
        return this.extractAmount == null ? 1 : this.extractAmount;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public boolean isEnabled(String tag) {
        if (tag.startsWith("flt")) {
            return true;
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        if (this.itemMode == InsExtMode.INS) {
            return INSERT_TAGS.contains(tag);
        }
        return EXTRACT_TAGS.contains(tag);
    }

    public void setSpeed(int speed) {
        this.speed = speed != 0 ? speed : 4;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.itemMode = CastTools.safeInsExtMode(data.get("mode"));
        this.extractMode = CastTools.safeExtractMode(data.get("extract"));
        this.stackMode = CastTools.safeStackMode(data.get("stack"));
        this.setSpeed(Integer.parseInt((String)data.get("speed")) / 5);
        String idx = (String)data.get("fltIdx");
        this.filterIndex = CastTools.safeIntOrValue(idx, -1);
        this.tagsMode = Boolean.TRUE.equals(data.get("od"));
        this.metaMode = Boolean.TRUE.equals(data.get("meta"));
        this.componentMode = Boolean.TRUE.equals(data.get("nbt"));
        this.blacklist = Boolean.TRUE.equals(data.get("blacklist"));
        this.priority = (Integer)data.get("priority");
        this.count = (Integer)data.get("count");
        this.extractAmount = (Integer)data.get("extractAmount");
        for (int i = 0; i < 18; ++i) {
            this.filters.set(i, (Object)((ItemStack)data.get("flt" + i)));
        }
        this.matcher = null;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"itemMode", (Enum)this.itemMode);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"extractMode", (Enum)this.extractMode);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"stackMode", (Enum)this.stackMode);
        object.add("tagsMode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.tagsMode)));
        object.add("metaMode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.metaMode)));
        object.add("nbtMode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.componentMode)));
        object.add("blacklist", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.blacklist)));
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"priority", (Integer)this.priority);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"extractAmount", (Integer)this.extractAmount);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"count", (Integer)this.count);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"speed", (Integer)this.speed);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"filterindex", (Integer)this.filterIndex);
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.filters.get(i)).isEmpty()) continue;
            object.add("flt" + i, JSonTools.itemStackToJson((ItemStack)((ItemStack)this.filters.get(i))));
        }
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.itemMode = (InsExtMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"itemMode", EnumStringTranslators::getItemMode);
        this.extractMode = (ExtractMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"extractMode", EnumStringTranslators::getExtractMode);
        this.stackMode = (StackMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"stackMode", EnumStringTranslators::getStackMode);
        this.tagsMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"tagsMode");
        this.metaMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"metaMode");
        this.componentMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"nbtMode");
        this.blacklist = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"blacklist");
        this.priority = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)"priority");
        this.extractAmount = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)"extractAmount");
        this.count = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)"count");
        this.speed = ItemConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"speed");
        this.filterIndex = object.has("filterindex") ? ItemConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"filterindex") : -1;
        for (int i = 0; i < 18; ++i) {
            if (object.has("flt" + i)) {
                this.filters.set(i, (Object)JSonTools.jsonToItemStack((JsonObject)object.get("flt" + i).getAsJsonObject()));
                continue;
            }
            this.filters.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
    }
}

