/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.controller.client;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.EnumChoiceLabel;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.xnet.channels.RSMode;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.modules.controller.client.GuiController;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractEditorPanel
implements IEditorGui {
    public static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"textures/gui/guielements.png");
    public static final int LEFTMARGIN = 3;
    public static final int TOPMARGIN = 3;
    private final Panel panel;
    private final Minecraft mc;
    private final GuiController gui;
    protected final Map<String, Object> data;
    protected final Map<String, Widget<?>> components = new HashMap();
    private int x;
    private int y;

    protected abstract void update(String var1, Object var2);

    public Widget<?> getComponent(String tag) {
        return this.components.get(tag);
    }

    protected void performUpdate(TypedMap.Builder builder, int i, Command<?> cmd) {
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof String) {
                builder.put(new Key(entry.getKey(), Type.STRING), (Object)((String)o));
                continue;
            }
            if (o instanceof Integer) {
                builder.put(new Key(entry.getKey(), Type.INTEGER), (Object)((Integer)o));
                continue;
            }
            if (o instanceof Boolean) {
                builder.put(new Key(entry.getKey(), Type.BOOLEAN), (Object)((Boolean)o));
                continue;
            }
            if (o instanceof Double) {
                builder.put(new Key(entry.getKey(), Type.DOUBLE), (Object)((Double)o));
                continue;
            }
            if (o instanceof ItemStack) {
                builder.put(new Key(entry.getKey(), Type.ITEMSTACK), (Object)((ItemStack)o));
                continue;
            }
            builder.put(new Key(entry.getKey(), Type.STRING), (Object)(o == null ? null : o.toString()));
        }
        this.gui.sendServerCommandTyped(cmd, builder.build());
        this.gui.refresh();
    }

    public AbstractEditorPanel(Panel panel, Minecraft mc, GuiController gui) {
        this.panel = panel;
        this.mc = mc;
        this.gui = gui;
        this.x = 3;
        this.y = 3;
        this.data = new HashMap<String, Object>();
    }

    public IEditorGui move(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public IEditorGui move(int x) {
        this.x = x;
        return this;
    }

    public IEditorGui shift(int x) {
        this.x += x;
        return this;
    }

    private void fitWidth(int w) {
        if (this.x + w > this.panel.getBounds().width) {
            this.nl();
        }
    }

    private String[] parseTooltips(String tooltip) {
        return StringUtils.split((String)tooltip, (char)'|');
    }

    public IEditorGui label(String txt) {
        int w = this.mc.font.width(txt) + 5;
        this.fitWidth(w);
        Label label = Widgets.label((int)this.x, (int)this.y, (int)w, (int)14, (String)txt);
        this.panel.children(new Widget[]{label});
        this.x += w;
        return this;
    }

    public IEditorGui text(String tag, String tooltip, String value, int width) {
        this.fitWidth(width);
        TextField text = (TextField)Widgets.textfield((int)this.x, (int)this.y, (int)width, (int)14).text(value).tooltips(this.parseTooltips(tooltip));
        this.data.put(tag, value);
        text.addTextEnterEvent(newText -> this.update(tag, newText));
        this.gui.getWindow().addFocusEvent(textFocus -> {
            if (textFocus == null) {
                this.update(tag, text.getText());
            }
        });
        this.panel.children(new Widget[]{text});
        this.components.put(tag, (Widget<?>)text);
        this.x += width;
        return this;
    }

    private Integer validate(String i, Integer maximum, Integer minimum) {
        if (i == null || i.isEmpty()) {
            return minimum;
        }
        try {
            int v = Integer.parseInt(i);
            if (maximum != null && v > maximum) {
                v = maximum;
            } else if (minimum != null && v < minimum) {
                v = minimum;
            }
            return v;
        }
        catch (NumberFormatException e) {
            return minimum;
        }
    }

    public IEditorGui integer(String tag, String tooltip, Integer value, int width) {
        this.fitWidth(width);
        TextField text = (TextField)Widgets.textfield((int)this.x, (int)this.y, (int)width, (int)14).text(value == null ? "" : value.toString()).tooltips(this.parseTooltips(tooltip));
        this.data.put(tag, value);
        text.addTextEnterEvent(newText -> this.update(tag, this.validate(newText, null, null)));
        this.gui.getWindow().addFocusEvent(textFocus -> {
            if (textFocus == null) {
                this.update(tag, this.validate(text.getText(), null, null));
            }
        });
        this.panel.children(new Widget[]{text});
        this.components.put(tag, (Widget<?>)text);
        this.x += width;
        return this;
    }

    public IEditorGui integer(String tag, String tooltip, Integer value, int width, Integer maximum) {
        return this.integer(tag, tooltip, value, width, maximum, 0);
    }

    public IEditorGui integer(String tag, String tooltip, Integer value, int width, int maximum, int minimum) {
        this.fitWidth(width);
        TextField text = (TextField)Widgets.textfield((int)this.x, (int)this.y, (int)width, (int)14).text(value == null ? String.valueOf(minimum) : value.toString()).tooltips(this.parseTooltips(tooltip));
        this.data.put(tag, value);
        text.addTextEnterEvent(newInt -> this.update(tag, this.validate(newInt, maximum, minimum)));
        this.gui.getWindow().addFocusEvent(textFocus -> {
            if (textFocus == null) {
                this.update(tag, this.validate(text.getText(), maximum, minimum));
            }
        });
        this.panel.children(new Widget[]{text});
        this.components.put(tag, (Widget<?>)text);
        this.x += width;
        return this;
    }

    private Double parseDouble(String i) {
        if (i == null || i.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(i);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public IEditorGui real(String tag, String tooltip, Double value, int width) {
        this.fitWidth(width);
        TextField text = (TextField)Widgets.textfield((int)this.x, (int)this.y, (int)width, (int)14).text(value == null ? "" : value.toString()).tooltips(this.parseTooltips(tooltip));
        this.data.put(tag, value);
        text.addTextEnterEvent(newText -> this.update(tag, this.parseDouble(newText)));
        text.event(newText -> this.update(tag, this.parseDouble(newText)));
        this.panel.children(new Widget[]{text});
        this.components.put(tag, (Widget<?>)text);
        this.x += width;
        return this;
    }

    public IEditorGui toggle(String tag, String tooltip, boolean value) {
        int w = 12;
        this.fitWidth(w);
        ToggleButton toggle = (ToggleButton)((ToggleButton)new ToggleButton().checkMarker(true).pressed(value).tooltips(this.parseTooltips(tooltip))).hint(this.x, this.y, w, 14);
        this.data.put(tag, value);
        toggle.event(() -> this.update(tag, toggle.isPressed()));
        this.panel.children(new Widget[]{toggle});
        this.components.put(tag, (Widget<?>)toggle);
        this.x += w;
        return this;
    }

    public IEditorGui toggleText(String tag, String tooltip, String text, boolean value) {
        int w = this.mc.font.width(text) + 10;
        this.fitWidth(w);
        ToggleButton toggle = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().checkMarker(false).pressed(value).text(text)).tooltips(this.parseTooltips(tooltip))).hint(this.x, this.y, w, 14);
        this.data.put(tag, value);
        toggle.event(() -> this.update(tag, toggle.isPressed()));
        this.panel.children(new Widget[]{toggle});
        this.components.put(tag, (Widget<?>)toggle);
        this.x += w;
        return this;
    }

    public IEditorGui colors(String tag, String tooltip, Integer current, Integer ... colors) {
        int w = 14;
        this.fitWidth(w);
        ColorChoiceLabel choice = (ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel().colors(colors).currentColor(current).tooltips(this.parseTooltips(tooltip))).hint(this.x, this.y, w, 14);
        this.data.put(tag, current);
        choice.event(newChoice -> this.update(tag, newChoice));
        this.panel.children(new Widget[]{choice});
        this.components.put(tag, (Widget<?>)choice);
        this.x += w;
        return this;
    }

    public IEditorGui choices(String tag, String tooltip, String current, String ... values) {
        int w = 10;
        for (String s : values) {
            w = Math.max(w, this.mc.font.width(s) + 14);
        }
        this.fitWidth(w);
        ChoiceLabel choice = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel().choices(values).choice(current).tooltips(this.parseTooltips(tooltip))).hint(this.x, this.y, w, 14);
        this.data.put(tag, current);
        choice.event(newChoice -> this.update(tag, newChoice));
        this.panel.children(new Widget[]{choice});
        this.components.put(tag, (Widget<?>)choice);
        this.x += w;
        return this;
    }

    public <T extends Enum<T>> IEditorGui choices(String tag, String tooltip, T current, T ... values) {
        String[] strings = new String[values.length];
        int i = 0;
        for (T s : values) {
            strings[i++] = StringUtils.capitalize((String)((Enum)s).toString().toLowerCase());
        }
        return this.choices(tag, tooltip, StringUtils.capitalize((String)current.toString().toLowerCase()), strings);
    }

    public IEditorGui translatableChoices(String tag, ITranslatableEnum<?> current, ITranslatableEnum<?> ... values) {
        int w = 10;
        for (ITranslatableEnum<?> s : values) {
            w = Math.max(w, this.mc.font.width(s.getI18n()) + 14);
        }
        this.fitWidth(w);
        EnumChoiceLabel choice = (EnumChoiceLabel)new EnumChoiceLabel().choices(values).choice(current).hint(this.x, this.y, w, 14);
        this.data.put(tag, current.ordinal());
        choice.event(newChoice -> this.update(tag, newChoice.ordinal()));
        this.panel.children(new Widget[]{choice});
        this.components.put(tag, (Widget<?>)choice);
        this.x += w;
        return this;
    }

    public IEditorGui redstoneMode(String tag, RSMode current) {
        int w = 14;
        this.fitWidth(w);
        ImageChoiceLabel redstoneMode = new ImageChoiceLabel().choice("Ignored", I18nConstants.RS_MODE_IGNORED_TOOLTIP.i18n(new Object[0]), iconGuiElements, 1, 1).choice("Off", I18nConstants.RS_MODE_OFF_TOOLTIP.i18n(new Object[0]), iconGuiElements, 17, 1).choice("On", I18nConstants.RS_MODE_ON_TOOLTIP.i18n(new Object[0]), iconGuiElements, 33, 1).choice("Pulse", I18nConstants.RS_MODE_PULSE_TOOLTIP.i18n(new Object[0]), iconGuiElements, 49, 1);
        switch (current) {
            case IGNORED: {
                redstoneMode.setCurrentChoice("Ignored");
                break;
            }
            case OFF: {
                redstoneMode.setCurrentChoice("Off");
                break;
            }
            case ON: {
                redstoneMode.setCurrentChoice("On");
                break;
            }
            case PULSE: {
                redstoneMode.setCurrentChoice("Pulse");
            }
        }
        redstoneMode.hint(this.x, this.y, w, 14);
        this.data.put(tag, current.name());
        redstoneMode.event(newChoice -> this.update(tag, newChoice));
        this.panel.children(new Widget[]{redstoneMode});
        this.components.put(tag, (Widget<?>)redstoneMode);
        this.x += w;
        return this;
    }

    public IEditorGui ghostSlot(final String tag, ItemStack stack) {
        int w = 16;
        this.fitWidth(w);
        final BlockRender blockRender = (BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender().renderItem((Object)stack).desiredWidth(18)).desiredHeight(18)).filledRectThickness(-1)).filledBackground(-7829368);
        blockRender.event(new BlockRenderEvent(){

            public void select() {
                ItemStack holding = Minecraft.getInstance().player.containerMenu.getCarried();
                if (holding.isEmpty()) {
                    AbstractEditorPanel.this.update(tag, holding);
                    blockRender.renderItem((Object)holding);
                } else {
                    ItemStack copy = holding.copy();
                    copy.setCount(1);
                    blockRender.renderItem((Object)copy);
                    AbstractEditorPanel.this.update(tag, copy);
                }
            }

            public void doubleClick() {
            }
        });
        blockRender.event(itemStack -> {
            this.update(tag, itemStack);
            blockRender.renderItem((Object)itemStack);
        });
        blockRender.hint(this.x, this.y - 1, 17, 17);
        this.data.put(tag, stack);
        this.panel.children(new Widget[]{blockRender});
        this.components.put(tag, (Widget<?>)blockRender);
        this.x += w;
        return this;
    }

    public IEditorGui nl() {
        this.y += 16;
        this.x = 3;
        return this;
    }
}

