/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.facade.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.blocks.FacadeBlock;
import mcjty.xnet.modules.facade.blocks.FacadeTileEntity;
import mcjty.xnet.modules.facade.blocks.ReplaceBlockItemUseContext;
import mcjty.xnet.modules.facade.data.MimicData;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;

public class FacadeBlockItem
extends BlockItem
implements ITooltipSettings {
    private Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> !FacadeBlockItem.isMimicking(stack)), TooltipBuilder.parameter((String)"info", FacadeBlockItem::isMimicking, FacadeBlockItem::getMimickingString)}));

    private static boolean isMimicking(ItemStack stack) {
        return !((MimicData)stack.getOrDefault(FacadeModule.ITEM_MIMIC_DATA, (Object)MimicData.EMPTY)).state().isAir();
    }

    private static String getMimickingString(ItemStack stack) {
        BlockState state = ((MimicData)stack.getOrDefault(FacadeModule.ITEM_MIMIC_DATA, (Object)MimicData.EMPTY)).state();
        if (!state.isAir()) {
            return state.getBlock().getDescriptionId();
        }
        return "<unset>";
    }

    public FacadeBlockItem(FacadeBlock block) {
        super((Block)block, XNet.setup.defaultProperties());
    }

    private static void userSetMimicBlock(@Nonnull ItemStack item, BlockState mimicBlock, UseOnContext context) {
        if (mimicBlock.isAir()) {
            return;
        }
        Level world = context.getLevel();
        Player player = context.getPlayer();
        FacadeBlockItem.setMimicBlock(item, mimicBlock);
        if (world.isClientSide) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)I18nConstants.FACADE_CURRENT_MIMIC_FORMATTED.i18n(mimicBlock.getBlock().getDescriptionId())), false);
        }
    }

    public static void setMimicBlock(@Nonnull ItemStack item, @Nonnull BlockState mimicBlock) {
        item.set(FacadeModule.ITEM_MIMIC_DATA, (Object)new MimicData(mimicBlock));
    }

    @Nonnull
    public static BlockState getMimicBlock(@Nonnull ItemStack stack) {
        return ((MimicData)stack.getOrDefault(FacadeModule.ITEM_MIMIC_DATA, (Object)MimicData.EMPTY)).state();
    }

    protected boolean canPlace(@Nonnull BlockPlaceContext context, @Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        ItemStack itemstack = context.getItemInHand();
        if (!itemstack.isEmpty()) {
            if (block == CableModule.NETCABLE.get()) {
                ReplaceBlockItemUseContext blockContext = new ReplaceBlockItemUseContext(context);
                FacadeBlock facadeBlock = (FacadeBlock)this.getBlock();
                BlockState placementState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)facadeBlock.getStateForPlacement(blockContext).setValue(GenericCableBlock.COLOR, (Comparable)((Object)((CableColor)((Object)state.getValue(GenericCableBlock.COLOR)))))).setValue(GenericCableBlock.NORTH, (Comparable)((Object)((ConnectorType)((Object)state.getValue(GenericCableBlock.NORTH)))))).setValue(GenericCableBlock.SOUTH, (Comparable)((Object)((ConnectorType)((Object)state.getValue(GenericCableBlock.SOUTH)))))).setValue(GenericCableBlock.WEST, (Comparable)((Object)((ConnectorType)((Object)state.getValue(GenericCableBlock.WEST)))))).setValue(GenericCableBlock.EAST, (Comparable)((Object)((ConnectorType)((Object)state.getValue(GenericCableBlock.EAST)))))).setValue(GenericCableBlock.UP, (Comparable)((Object)((ConnectorType)((Object)state.getValue(GenericCableBlock.UP)))))).setValue(GenericCableBlock.DOWN, (Comparable)((Object)((ConnectorType)((Object)state.getValue(GenericCableBlock.DOWN)))));
                if (this.placeBlock(blockContext, placementState)) {
                    SoundType soundtype = world.getBlockState(pos).getBlock().getSoundType(world.getBlockState(pos), (LevelReader)world, pos, (Entity)player);
                    world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    BlockEntity te = world.getBlockEntity(pos);
                    if (te instanceof FacadeTileEntity) {
                        ((FacadeTileEntity)te).setMimicBlock(FacadeBlockItem.getMimicBlock(itemstack));
                    }
                    int amount = -1;
                    itemstack.grow(amount);
                }
            } else if (block == CableModule.CONNECTOR.get() || block == CableModule.ADVANCED_CONNECTOR.get()) {
                BlockEntity te = world.getBlockEntity(pos);
                if (te instanceof ConnectorTileEntity) {
                    ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
                    if (connectorTileEntity.getMimicBlock() == null) {
                        connectorTileEntity.setMimicBlock(FacadeBlockItem.getMimicBlock(itemstack));
                        SoundType soundtype = world.getBlockState(pos).getBlock().getSoundType(world.getBlockState(pos), (LevelReader)world, pos, (Entity)player);
                        world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                        int amount = -1;
                        itemstack.grow(amount);
                    } else {
                        FacadeBlockItem.userSetMimicBlock(itemstack, connectorTileEntity.getMimicBlock(), context);
                    }
                }
            } else if (block == FacadeModule.FACADE.get()) {
                BlockEntity te = world.getBlockEntity(pos);
                if (!(te instanceof IFacadeSupport)) {
                    return InteractionResult.FAIL;
                }
                IFacadeSupport facade = (IFacadeSupport)te;
                if (facade.getMimicBlock() == null) {
                    return InteractionResult.FAIL;
                }
                FacadeBlockItem.userSetMimicBlock(itemstack, facade.getMimicBlock(), context);
            } else {
                FacadeBlockItem.userSetMimicBlock(itemstack, state, context);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), stack, tooltip, flag);
    }
}

