/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.router.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.controller.ChannelInfo;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.controller.data.ControllerData;
import mcjty.xnet.modules.router.LocalChannelId;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.modules.router.data.RouterData;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public final class TileEntityRouter
extends GenericTileEntity {
    public List<ControllerChannelClientInfo> clientLocalChannels = null;
    public List<ControllerChannelClientInfo> clientRemoteChannels = null;
    @Cap(type=CapType.CONTAINER)
    private static final Function<TileEntityRouter, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Router").containerSupplier(DefaultContainerProvider.empty(RouterModule.CONTAINER_ROUTER, (GenericTileEntity)be));
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<Integer> PARAM_CHANNEL = new Key("channel", Type.INTEGER);
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_UPDATENAME = Command.create((String)"router.updateName", (te, player, params) -> te.updatePublishName((BlockPos)params.get(PARAM_POS), (Integer)params.get(PARAM_CHANNEL), (String)params.get(PARAM_NAME)));
    @ServerCommand(type=ControllerChannelClientInfo.class, serializer=ControllerChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETCHANNELS = ListCommand.create((String)"xnet.router.getChannelInfo", (te, player, params) -> {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        te.findLocalChannelInfo(list, false, false);
        return list;
    }, (te, player, params, list) -> {
        te.clientLocalChannels = list;
    });
    @ServerCommand(type=ControllerChannelClientInfo.class, serializer=ControllerChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETREMOTECHANNELS = ListCommand.create((String)"xnet.router.getRemoteChannelInfo", (te, player, params) -> {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        te.findRemoteChannelInfo(list);
        return list;
    }, (te, player, params, list) -> {
        te.clientRemoteChannels = list;
    });

    public TileEntityRouter(BlockPos pos, BlockState state) {
        super((BlockEntityType)RouterModule.ROUTER.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityRouter::new).manualEntry(ManualHelper.create((String)"rftoolsbase:network/router")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[]{TileEntityController.ERROR});
            }

            @Nullable
            public BlockState getStateForPlacement(BlockPlaceContext context) {
                return (BlockState)super.getStateForPlacement(context).setValue((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false));
            }
        };
    }

    public void addPublishedChannels(Set<String> channels) {
        channels.addAll(((RouterData)this.getData(RouterModule.ROUTER_DATA)).publishedChannels().values());
    }

    public int countPublishedChannelsOnNet() {
        HashSet channels = new HashSet();
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.forEachRouter(this.level, networkId, router -> router.addPublishedChannels(channels));
        }
        return channels.size();
    }

    public boolean inError() {
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        return data.channelCount() > (Integer)Config.maxPublishedChannels.get();
    }

    public int getChannelCount() {
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        return data.channelCount();
    }

    public void setChannelCount(int cnt) {
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        if (data.channelCount() == cnt) {
            return;
        }
        data = data.withChannelCount(cnt);
        this.setData(RouterModule.ROUTER_DATA, data);
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (this.inError()) {
            if (!((Boolean)state.getValue((Property)TileEntityController.ERROR)).booleanValue()) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (((Boolean)state.getValue((Property)TileEntityController.ERROR)).booleanValue()) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void forEachPublishedChannel(BiConsumer<String, IChannelType> consumer) {
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        LogicTools.forEachConnector(this.level, this.worldPosition, connectorPos -> {
            TileEntityController controller = LogicTools.getControllerForConnector(this.level, connectorPos);
            if (controller != null) {
                ControllerData controllerData = (ControllerData)controller.getData(ControllerModule.CONTROLLER_DATA);
                for (int i = 0; i < 8; ++i) {
                    ChannelInfo channelInfo = controllerData.channels().get(i);
                    if (channelInfo.isEmpty() || channelInfo.getChannelName().isEmpty()) continue;
                    LocalChannelId id = new LocalChannelId(controller.getBlockPos(), i);
                    String publishedName = data.publishedChannels().get(id);
                    if (publishedName == null || publishedName.isEmpty()) continue;
                    consumer.accept(publishedName, channelInfo.getType());
                }
            }
        });
    }

    public void findLocalChannelInfo(List<ControllerChannelClientInfo> list, boolean onlyPublished, boolean remote) {
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        LogicTools.forEachConnector(this.level, this.getBlockPos(), connectorPos -> {
            TileEntityController controller = LogicTools.getControllerForConnector(this.level, connectorPos);
            if (controller != null) {
                ControllerData controllerData = (ControllerData)controller.getData(ControllerModule.CONTROLLER_DATA);
                for (int i = 0; i < 8; ++i) {
                    ChannelInfo channelInfo = controllerData.channels().get(i);
                    if (channelInfo.isEmpty() || channelInfo.getChannelName().isEmpty()) continue;
                    LocalChannelId id = new LocalChannelId(controller.getBlockPos(), i);
                    String publishedName = data.publishedChannels().get(id);
                    if (publishedName == null) {
                        publishedName = "";
                    }
                    if (onlyPublished && publishedName.isEmpty()) continue;
                    ControllerChannelClientInfo ci = new ControllerChannelClientInfo(channelInfo.getChannelName(), publishedName, controller.getBlockPos(), channelInfo.getType(), remote, i);
                    if (!list.stream().noneMatch(ii -> Objects.equals(ii.getPublishedName(), ci.getPublishedName()) && Objects.equals(ii.getChannelName(), ci.getChannelName()) && Objects.equals(ii.getChannelType(), ci.getChannelType()) && Objects.equals(ii.getPos(), ci.getPos()))) continue;
                    list.add(ci);
                }
            }
        });
    }

    private void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.consumers(this.level, networkId).forEach(consumerPos -> {
                LogicTools.forEachRouter(this.level, consumerPos, router -> {
                    if (router != this) {
                        router.findLocalChannelInfo(list, true, false);
                    }
                });
                LogicTools.forEachWirelessRouter(this.level, consumerPos, router -> {
                    if (!router.inError()) {
                        router.findRemoteChannelInfo(list);
                    }
                });
            });
        }
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.get(this.level).getWorldBlob(this.level);
        return LogicTools.findRoutingConnector(this.level, this.getBlockPos(), worldBlob::getNetworkAt);
    }

    public void addRoutedConnectors(Map<SidedConsumer, IConnectorSettings> connectors, @Nonnull BlockPos controllerPos, int channel, IChannelType type) {
        if (this.inError()) {
            return;
        }
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        String publishedName = data.publishedChannels().get(id);
        if (publishedName != null && !publishedName.isEmpty()) {
            NetworkId networkId = this.findRoutingNetwork();
            if (networkId != null) {
                LogicTools.consumers(this.level, networkId).forEach(consumerPos -> {
                    LogicTools.forEachRouter(this.level, consumerPos, router -> router.addConnectorsFromConnectedNetworks(connectors, publishedName, type));
                    LogicTools.forEachWirelessRouter(this.level, consumerPos, router -> {
                        if (!router.inError()) {
                            router.addWirelessConnectors(connectors, publishedName, type, null);
                            router.addWirelessConnectors(connectors, publishedName, type, this.getOwnerUUID());
                        }
                    });
                });
            } else {
                this.addConnectorsFromConnectedNetworks(connectors, publishedName, type);
            }
        }
    }

    public void addConnectorsFromConnectedNetworks(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type) {
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        LogicTools.forEachConnector(this.level, this.getBlockPos(), connectorPos -> {
            TileEntityController controller = LogicTools.getControllerForConnector(this.level, connectorPos);
            if (controller != null) {
                ControllerData controllerData = (ControllerData)controller.getData(ControllerModule.CONTROLLER_DATA);
                for (int i = 0; i < 8; ++i) {
                    String publishedName;
                    ChannelInfo info = controllerData.channels().get(i);
                    if (info.isEmpty() || !info.isEnabled() || (publishedName = data.publishedChannels().get(new LocalChannelId(controller.getBlockPos(), i))) == null || publishedName.isEmpty() || !channelName.equals(publishedName) || !type.equals((Object)info.getType())) continue;
                    connectors.putAll(controller.getConnectors(i));
                }
            }
        });
    }

    private void updatePublishName(@Nonnull BlockPos controllerPos, int channel, String name) {
        RouterData data = (RouterData)this.getData(RouterModule.ROUTER_DATA);
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        data = name.isEmpty() ? data.removeChannel(id) : data.addChannel(id, name);
        this.setData(RouterModule.ROUTER_DATA, data);
        int number = this.countPublishedChannelsOnNet();
        WorldBlob worldBlob = XNetBlobData.get(this.level).getWorldBlob(this.level);
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            if (number != data.channelCount()) {
                LogicTools.forEachRouter(this.level, networkId, router -> router.setChannelCount(number));
            }
            worldBlob.markNetworkDirty(networkId);
        }
        for (NetworkId net : worldBlob.getNetworksAt(this.worldPosition)) {
            worldBlob.markNetworkDirty(net);
        }
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            for (NetworkId net : worldBlob.getNetworksAt(this.worldPosition.relative(facing))) {
                worldBlob.markNetworkDirty(net);
            }
        }
        XNetWirelessChannels.get(this.level).updateGlobalChannelVersion();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        RouterData data = (RouterData)input.get(RouterModule.ITEM_ROUTER_DATA);
        if (data != null) {
            this.setData(RouterModule.ROUTER_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(RouterModule.ITEM_ROUTER_DATA, (Object)((RouterData)this.getData(RouterModule.ROUTER_DATA)));
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.getBlock() == newstate.getBlock()) {
            return;
        }
        if (!this.level.isClientSide) {
            XNetBlobData blobData = XNetBlobData.get(this.level);
            WorldBlob worldBlob = blobData.getWorldBlob(this.level);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }
}

