/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityCockatriceEgg
extends ThrowableItemProjectile {
    public EntityCockatriceEgg(EntityType<? extends ThrowableItemProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityCockatriceEgg(EntityType<? extends ThrowableItemProjectile> type, Level worldIn, LivingEntity throwerIn) {
        super(type, throwerIn, worldIn);
    }

    public EntityCockatriceEgg(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level worldIn) {
        super(type, x, y, z, worldIn);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHit(HitResult result) {
        Entity thrower = this.getOwner();
        if (result.getType() == HitResult.Type.ENTITY) {
            ((EntityHitResult)result).getEntity().hurt(this.level().damageSources().thrown((Entity)this, thrower), 0.0f);
        }
        if (!this.level().isClientSide) {
            if (this.random.nextInt(4) == 0) {
                int i = 1;
                if (this.random.nextInt(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    EntityCockatrice cockatrice = new EntityCockatrice((EntityType<EntityCockatrice>)((EntityType)IafEntities.COCKATRICE.get()), this.level());
                    cockatrice.setAge(-24000);
                    cockatrice.setHen(this.random.nextBoolean());
                    cockatrice.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    if (thrower instanceof Player) {
                        cockatrice.tame((Player)thrower);
                    }
                    this.level().addFreshEntity((Entity)cockatrice);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected Item getDefaultItem() {
        return (Item)IafItems.ROTTEN_EGG.get();
    }
}

