/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.registry.IafItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityDragonArrow
extends AbstractArrow {
    public EntityDragonArrow(EntityType<? extends AbstractArrow> typeIn, Level worldIn) {
        super(typeIn, worldIn);
        this.setBaseDamage(10.0);
    }

    public EntityDragonArrow(EntityType<? extends AbstractArrow> typeIn, double x, double y, double z, Level world, ItemStack stack, @Nullable ItemStack shotFrom) {
        super(typeIn, x, y, z, world, stack, shotFrom);
        this.setBaseDamage(10.0);
    }

    public EntityDragonArrow(EntityType<? extends AbstractArrow> typeIn, LivingEntity shooter, Level worldIn, ItemStack from) {
        super(typeIn, shooter, worldIn, new ItemStack((ItemLike)IafItems.DRAGONBONE_ARROW.get()), from);
        this.setBaseDamage(10.0);
    }

    public void addAdditionalSaveData(CompoundTag tagCompound) {
        super.addAdditionalSaveData(tagCompound);
        tagCompound.putDouble("damage", 10.0);
    }

    public void readAdditionalSaveData(CompoundTag tagCompund) {
        super.readAdditionalSaveData(tagCompund);
        this.setBaseDamage(tagCompund.getDouble("damage"));
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)IafItems.DRAGONBONE_ARROW.get());
    }
}

