/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityEggInIce;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.item.ItemDragonEgg;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.object.BlockUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EntityDragonEgg
extends LivingEntity
implements IBlacklistedFromStatues,
IDeadMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(EntityDragonEgg.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> DRAGON_TYPE = SynchedEntityData.defineId(EntityDragonEgg.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> DRAGON_AGE = SynchedEntityData.defineId(EntityDragonEgg.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public EntityDragonEgg(EntityType<EntityDragonEgg> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Color", this.getEggType().name());
        tag.putInt("DragonAge", this.getDragonAge());
        try {
            if (this.getOwnerId() == null) {
                tag.putString("OwnerUUID", "");
            } else {
                tag.putString("OwnerUUID", this.getOwnerId().toString());
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error("An error occurred while trying to read the NBT data of a dragon egg", (Throwable)e);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        String s;
        super.readAdditionalSaveData(tag);
        this.setEggType(DragonColor.getById(tag.getString("Color")));
        this.setDragonAge(tag.getInt("DragonAge"));
        if (tag.contains("OwnerUUID", 8)) {
            s = tag.getString("OwnerUUID");
        } else {
            String s1 = tag.getString("Owner");
            UUID converedUUID = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s1);
            String string = s = converedUUID == null ? s1 : converedUUID.toString();
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DRAGON_TYPE, (Object)DragonColor.RED.toString());
        builder.define(DRAGON_AGE, (Object)0);
        builder.define(OWNER_UNIQUE_ID, Optional.empty());
    }

    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(UUID p_184754_1_) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public DragonColor getEggType() {
        return DragonColor.getById((String)this.getEntityData().get(DRAGON_TYPE));
    }

    public void setEggType(DragonColor newtype) {
        this.getEntityData().set(DRAGON_TYPE, (Object)newtype.name());
    }

    public boolean isInvulnerableTo(DamageSource i) {
        return i.getEntity() != null && super.isInvulnerableTo(i);
    }

    public int getDragonAge() {
        return (Integer)this.getEntityData().get(DRAGON_AGE);
    }

    public void setDragonAge(int i) {
        this.getEntityData().set(DRAGON_AGE, (Object)i);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setAirSupply(200);
            this.updateEggCondition();
        }
    }

    public void updateEggCondition() {
        DragonType dragonType = this.getEggType().dragonType();
        if (dragonType == DragonType.FIRE) {
            if (BlockUtil.isBurning((BlockState)this.level().getBlockState(this.blockPosition()))) {
                this.setDragonAge(this.getDragonAge() + 1);
            }
        } else if (dragonType == DragonType.ICE) {
            BlockState state = this.level().getBlockState(this.blockPosition());
            if (state.is(Blocks.WATER) && this.getRandom().nextInt(500) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), ((Block)IafBlocks.EGG_IN_ICE.get()).defaultBlockState());
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), SoundEvents.GLASS_BREAK, this.getSoundSource(), 2.5f, 1.0f, false);
                BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
                if (blockEntity instanceof BlockEntityEggInIce) {
                    BlockEntityEggInIce eggInIce = (BlockEntityEggInIce)blockEntity;
                    eggInIce.type = this.getEggType();
                    eggInIce.ownerUUID = this.getOwnerId();
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else if (dragonType == DragonType.LIGHTNING) {
            boolean isRainingAt;
            BlockPos.MutableBlockPos mutablePosition = new BlockPos.MutableBlockPos(this.getX(), this.getY(), this.getZ());
            boolean bl = isRainingAt = this.level().isRainingAt((BlockPos)mutablePosition) || this.level().isRainingAt((BlockPos)mutablePosition.set(this.getX(), this.getY() + (double)this.getBbHeight(), this.getZ()));
            if (this.level().canSeeSky(this.blockPosition().above()) && isRainingAt) {
                this.setDragonAge(this.getDragonAge() + 1);
            }
        }
        if (this.getDragonAge() > (Integer)IafCommonConfig.INSTANCE.dragon.eggBornTime.getValue()) {
            this.level().setBlockAndUpdate(this.blockPosition(), Blocks.AIR.defaultBlockState());
            EntityDragonBase dragon = (EntityDragonBase)dragonType.getEntity().create(this.level());
            if (this.hasCustomName()) {
                assert (dragon != null);
                dragon.setCustomName(this.getCustomName());
            }
            assert (dragon != null);
            dragon.setVariant(this.getEggType().name());
            dragon.setGender(this.getRandom().nextBoolean());
            dragon.setPos((double)this.blockPosition().getX() + 0.5, this.blockPosition().getY() + 1, (double)this.blockPosition().getZ() + 0.5);
            dragon.setHunger(50);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)dragon);
            }
            if (this.hasCustomName()) {
                dragon.setCustomName(this.getCustomName());
            }
            dragon.setTame(true, true);
            dragon.setOwnerUUID(this.getOwnerId());
            if (dragonType == DragonType.LIGHTNING) {
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                assert (bolt != null);
                bolt.setPos(this.getX(), this.getY(), this.getZ());
                bolt.setVisualOnly(true);
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)bolt);
                }
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, this.getSoundSource(), 2.5f, 1.0f, false);
            } else if (dragonType == DragonType.FIRE) {
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), SoundEvents.FIRE_EXTINGUISH, this.getSoundSource(), 2.5f, 1.0f, false);
            }
            this.level().playLocalSound(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), (SoundEvent)IafSounds.EGG_HATCH.get(), this.getSoundSource(), 2.5f, 1.0f, false);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return ImmutableList.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
    }

    public boolean hurt(DamageSource var1, float var2) {
        if (var1.is(DamageTypeTags.IS_FIRE) && this.getEggType().dragonType() == DragonType.FIRE) {
            return false;
        }
        if (!(this.level().isClientSide || var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || this.isRemoved())) {
            this.spawnAtLocation((ItemLike)this.getItem().getItem(), 1);
        }
        this.remove(Entity.RemovalReason.KILLED);
        return true;
    }

    private ItemStack getItem() {
        return new ItemStack((ItemLike)ItemDragonEgg.EGGS.getOrDefault(this.getEggType(), Items.AIR));
    }

    public boolean isPushable() {
        return false;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected void doPush(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(Player player) {
        this.setOwnerId(player.getUUID());
    }

    @Override
    public boolean isMobDead() {
        return true;
    }
}

