/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityHydraArrow
extends AbstractArrow {
    public EntityHydraArrow(EntityType<? extends AbstractArrow> t, Level worldIn) {
        super(t, worldIn);
        this.setBaseDamage(5.0);
    }

    public EntityHydraArrow(EntityType<? extends AbstractArrow> t, Level worldIn, double x, double y, double z) {
        this(t, worldIn);
        this.setPos(x, y, z);
        this.setBaseDamage(5.0);
    }

    public EntityHydraArrow(EntityType<? extends EntityHydraArrow> t, Level worldIn, LivingEntity shooter, ItemStack shotFrom) {
        super(t, shooter, worldIn, new ItemStack((ItemLike)IafItems.HYDRA_ARROW.get()), shotFrom);
        this.setBaseDamage(5.0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && !this.inGround) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = 10.0;
            double xRatio = this.getDeltaMovement().x * (double)this.getBbHeight();
            double zRatio = this.getDeltaMovement().z * (double)this.getBbHeight();
            this.level().addParticle((ParticleOptions)IafParticles.HYDRA_BREATH.get(), this.getX() + xRatio + (double)(this.random.nextFloat() * this.getBbWidth() * 1.0f) - (double)this.getBbWidth() - d0 * 10.0, this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()) - d1 * 10.0, this.getZ() + zRatio + (double)(this.random.nextFloat() * this.getBbWidth() * 1.0f) - (double)this.getBbWidth() - d2 * 10.0, 0.1, 1.0, 0.1);
            this.level().addParticle((ParticleOptions)IafParticles.HYDRA_BREATH.get(), this.getX() + xRatio + (double)(this.random.nextFloat() * this.getBbWidth() * 1.0f) - (double)this.getBbWidth() - d0 * 10.0, this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()) - d1 * 10.0, this.getZ() + zRatio + (double)(this.random.nextFloat() * this.getBbWidth() * 1.0f) - (double)this.getBbWidth() - d2 * 10.0, 0.1, 1.0, 0.1);
        }
    }

    protected void damageShield(Player player, float damage) {
        if (damage >= 3.0f && player.getUseItem().getItem() instanceof ShieldItem) {
            ItemStack copyBeforeUse = player.getUseItem().copy();
            int i = 1 + Mth.floor((float)damage);
            player.getUseItem().hurtAndBreak(i, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            if (player.getUseItem().isEmpty()) {
                player.stopUsingItem();
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            }
        }
    }

    protected void doPostHurtEffects(LivingEntity living) {
        if (living instanceof Player) {
            Player player = (Player)living;
            this.damageShield(player, (float)this.getBaseDamage());
        }
        living.addEffect(new MobEffectInstance(MobEffects.POISON, 300, 0));
        Entity shootingEntity = this.getOwner();
        if (shootingEntity instanceof LivingEntity) {
            LivingEntity living1 = (LivingEntity)shootingEntity;
            living1.heal((float)this.getBaseDamage());
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)IafItems.HYDRA_ARROW.get());
    }
}

