/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.entity.EntityHydraHead;
import com.iafenvoy.iceandfire.entity.util.dragon.IDragonProjectile;
import com.iafenvoy.iceandfire.registry.IafParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityHydraBreath
extends Fireball
implements IDragonProjectile {
    public EntityHydraBreath(EntityType<? extends Fireball> t, Level worldIn) {
        super(t, worldIn);
    }

    public EntityHydraBreath(EntityType<? extends Fireball> t, Level worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(t, posX, posY, posZ, new Vec3(accelX, accelY, accelZ), worldIn);
    }

    public EntityHydraBreath(EntityType<? extends Fireball> t, Level worldIn, EntityHydra shooter, double accelX, double accelY, double accelZ) {
        super(t, (LivingEntity)shooter, new Vec3(accelX, accelY, accelZ), worldIn);
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public boolean isPickable() {
        return false;
    }

    public void tick() {
        this.clearFire();
        if (this.tickCount > 30) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Entity shootingEntity = this.getOwner();
        if (this.level().isClientSide || (shootingEntity == null || shootingEntity.isAlive()) && this.level().hasChunkAt(this.blockPosition())) {
            HitResult raytraceresult;
            this.baseTick();
            if (this.shouldBurn()) {
                this.igniteForSeconds(1.0f);
            }
            if ((raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS) {
                this.onHit(raytraceresult);
            }
            Vec3 Vector3d = this.getDeltaMovement();
            double d0 = this.getX() + Vector3d.x;
            double d1 = this.getY() + Vector3d.y;
            double d2 = this.getZ() + Vector3d.z;
            ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
            float f = this.getInertia();
            if (this.level().isClientSide) {
                for (int i = 0; i < 15; ++i) {
                    this.level().addParticle((ParticleOptions)IafParticles.HYDRA_BREATH.get(), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() - 0.5, this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, 0.1, 1.0, 0.1);
                }
            }
            Vec3 vec3d = this.getDeltaMovement();
            this.setDeltaMovement(vec3d.add(vec3d.normalize().scale(this.accelerationPower)).scale((double)this.getInertia()));
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - this.getDeltaMovement().x * 0.25, this.getY() - this.getDeltaMovement().y * 0.25, this.getZ() - this.getDeltaMovement().z * 0.25, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
                }
            }
            this.setPos(d0, d1, d2);
            this.setPos(this.getX(), this.getY(), this.getZ());
        }
    }

    protected void onHit(HitResult movingObject) {
        this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        Entity shootingEntity = this.getOwner();
        if (!this.level().isClientSide && movingObject.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)movingObject).getEntity();
            if (entity instanceof EntityHydraHead) {
                return;
            }
            if (shootingEntity instanceof EntityHydra) {
                EntityHydra dragon = (EntityHydra)shootingEntity;
                if (dragon.isAlliedTo(entity) || dragon.is(entity)) {
                    return;
                }
                entity.hurt(this.level().damageSources().mobAttack((LivingEntity)dragon), 2.0f);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.POISON, 60, 0));
                }
            }
        }
    }
}

