/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.registry.IafItems;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityStymphalianArrow
extends AbstractArrow {
    public EntityStymphalianArrow(EntityType<? extends AbstractArrow> t, Level worldIn) {
        super(t, worldIn);
        this.setBaseDamage(3.5);
    }

    public EntityStymphalianArrow(EntityType<? extends AbstractArrow> t, Level worldIn, double x, double y, double z) {
        this(t, worldIn);
        this.setPos(x, y, z);
        this.setBaseDamage(3.5);
    }

    public EntityStymphalianArrow(EntityType<? extends AbstractArrow> t, Level worldIn, LivingEntity shooter, ItemStack from) {
        super(t, shooter, worldIn, new ItemStack((ItemLike)IafItems.STYMPHALIAN_ARROW.get()), from);
        this.setBaseDamage(3.5);
    }

    public void tick() {
        super.tick();
        float sqrt = Mth.sqrt((float)((float)(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z)));
        if (sqrt < 0.1f) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.01f, 0.0));
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)IafItems.STYMPHALIAN_ARROW.get());
    }

    public boolean isNoGravity() {
        return true;
    }
}

