/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AquaticAIFindWaterTarget
extends Goal {
    protected final Sorter fleePosSorter;
    private final Mob mob;

    public AquaticAIFindWaterTarget(Mob mob, int range, boolean avoidAttacker) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.fleePosSorter = new Sorter((Entity)mob);
    }

    public boolean canUse() {
        if (!this.mob.isInWater() || this.mob.isPassenger() || this.mob.isVehicle()) {
            return false;
        }
        Path path = this.mob.getNavigation().getPath();
        if (this.mob.getRandom().nextFloat() < 0.15f && path != null && path.getEndNode() != null && this.mob.distanceToSqr((double)path.getEndNode().x, (double)path.getEndNode().y, (double)path.getEndNode().z) < 3.0) {
            BlockPos vec3;
            assert (path.getEndNode() != null);
            if (path.getEndNode() != null || !this.mob.getNavigation().isDone() && !this.isDirectPathBetweenPoints((Entity)this.mob, this.mob.position(), new Vec3((double)path.getEndNode().x, (double)path.getEndNode().y, (double)path.getEndNode().z))) {
                this.mob.getNavigation().stop();
            }
            if (this.mob.getNavigation().isDone() && (vec3 = this.findWaterTarget()) != null) {
                this.mob.getNavigation().moveTo((double)vec3.getX(), (double)vec3.getY(), (double)vec3.getZ(), 1.0);
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public BlockPos findWaterTarget() {
        BlockPos blockpos = BlockPos.containing((double)this.mob.getBlockX(), (double)this.mob.getBoundingBox().minY, (double)this.mob.getBlockZ());
        if (this.mob.getTarget() == null || !this.mob.getTarget().isAlive()) {
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.offset(this.mob.getRandom().nextInt(20) - 10, this.mob.getRandom().nextInt(6) - 3, this.mob.getRandom().nextInt(20) - 10);
                if (!this.mob.level().getBlockState(blockpos1).is(Blocks.WATER)) continue;
                return blockpos1;
            }
        } else {
            return this.mob.getTarget().blockPosition();
        }
        return null;
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3 vec1, Vec3 vec2) {
        return this.mob.level().clip(new ClipContext(vec1, vec2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS;
    }

    public class Sorter
    implements Comparator<BlockPos> {
        private BlockPos pos;

        public Sorter(Entity theEntityIn) {
            this.pos = theEntityIn.blockPosition();
        }

        @Override
        public int compare(BlockPos p_compare_1_, BlockPos p_compare_2_) {
            this.pos = AquaticAIFindWaterTarget.this.mob.blockPosition();
            double d0 = this.pos.distSqr((Vec3i)p_compare_1_);
            double d1 = this.pos.distSqr((Vec3i)p_compare_2_);
            return Double.compare(d1, d0);
        }
    }
}

