/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.phys.Vec3;

public class DeathWormAIJump
extends JumpGoal {
    private static final int[] JUMP_DISTANCES = new int[]{0, 1, 4, 5, 6, 7};
    private final EntityDeathWorm dolphin;
    private final int chance;
    private boolean inWater;
    private int jumpCooldown;

    public DeathWormAIJump(EntityDeathWorm dolphin, int p_i50329_2_) {
        this.dolphin = dolphin;
        this.chance = p_i50329_2_;
    }

    public boolean canUse() {
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.dolphin.getRandom().nextInt(this.chance) != 0 || this.dolphin.isVehicle() || this.dolphin.getTarget() != null) {
            return false;
        }
        Direction direction = this.dolphin.getMotionDirection();
        int i = direction.getStepX();
        int j = direction.getStepZ();
        BlockPos blockpos = this.dolphin.blockPosition();
        for (int k : JUMP_DISTANCES) {
            if (this.canJumpTo(blockpos, i, j, k) && this.isAirAbove(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.offset(dx * scale, 0, dz * scale);
        return this.dolphin.level().getBlockState(blockpos).is(BlockTags.SAND);
    }

    private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
        return this.dolphin.level().getBlockState(pos.offset(dx * scale, 1, dz * scale)).isAir() && this.dolphin.level().getBlockState(pos.offset(dx * scale, 2, dz * scale)).isAir();
    }

    public boolean canContinueToUse() {
        double d0 = this.dolphin.getDeltaMovement().y;
        return this.jumpCooldown > 0 && (d0 * d0 >= (double)0.03f || this.dolphin.getXRot() == 0.0f || Math.abs(this.dolphin.getXRot()) >= 10.0f || !this.dolphin.isInSand()) && !this.dolphin.onGround();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        Direction direction = this.dolphin.getMotionDirection();
        float up = (this.dolphin.getAgeScale() > 3.0f ? 0.7f : 0.4f) + this.dolphin.getRandom().nextFloat() * 0.4f;
        this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add((double)direction.getStepX() * 0.6, (double)up, (double)direction.getStepZ() * 0.6));
        this.dolphin.getNavigation().stop();
        this.dolphin.setWormJumping(30);
        this.jumpCooldown = this.dolphin.getRandom().nextInt(65) + 32;
    }

    public void stop() {
        this.dolphin.setXRot(0.0f);
    }

    public void tick() {
        boolean flag = this.inWater;
        if (!flag) {
            this.inWater = this.dolphin.level().getBlockState(this.dolphin.blockPosition()).is(BlockTags.SAND);
        }
        Vec3 vector3d = this.dolphin.getDeltaMovement();
        if (vector3d.y * vector3d.y < (double)0.1f && this.dolphin.getXRot() != 0.0f) {
            this.dolphin.setXRot(Mth.rotLerp((float)this.dolphin.getXRot(), (float)0.0f, (float)0.2f));
        } else {
            double d0 = vector3d.horizontalDistance();
            double d1 = Math.signum(-vector3d.y) * Math.acos(d0 / vector3d.length()) * 57.2957763671875;
            this.dolphin.setXRot((float)d1);
        }
    }
}

