/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.delegate.DragonForgePropertyDelegate;
import com.iafenvoy.iceandfire.item.block.BlockDragonForgeBricks;
import com.iafenvoy.iceandfire.item.block.BlockDragonForgeCore;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.iafenvoy.iceandfire.screen.handler.DragonForgeScreenHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEntityDragonForge
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{2};
    private static final int[] SLOTS_SIDES = new int[]{0, 1};
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final DragonForgePropertyDelegate propertyDelegate = new DragonForgePropertyDelegate();
    public int lastDragonFlameTimer = 0;
    private NonNullList<ItemStack> forgeItemStacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private boolean prevAssembled;
    private boolean canAddFlameAgain = true;

    public BlockEntityDragonForge(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.DRAGONFORGE_CORE.get(), pos, state);
    }

    public BlockEntityDragonForge(BlockPos pos, BlockState state, int fireType) {
        super((BlockEntityType)IafBlockEntities.DRAGONFORGE_CORE.get(), pos, state);
        this.getPropertyDelegate().fireType = fireType;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntityDragonForge entityDragonforge) {
        boolean flag = entityDragonforge.isBurning();
        boolean flag1 = false;
        entityDragonforge.getPropertyDelegate().fireType = entityDragonforge.getFireType(entityDragonforge.getBlockState().getBlock());
        if (entityDragonforge.lastDragonFlameTimer > 0) {
            --entityDragonforge.lastDragonFlameTimer;
        }
        entityDragonforge.updateGrills(entityDragonforge.assembled());
        if (!level.isClientSide) {
            if (entityDragonforge.prevAssembled != entityDragonforge.assembled()) {
                BlockDragonForgeCore.setState(entityDragonforge.getPropertyDelegate().fireType, entityDragonforge.prevAssembled, level, pos);
            }
            entityDragonforge.prevAssembled = entityDragonforge.assembled();
            if (!entityDragonforge.assembled()) {
                return;
            }
        }
        if (entityDragonforge.getPropertyDelegate().cookTime > 0 && entityDragonforge.canSmelt() && entityDragonforge.lastDragonFlameTimer == 0) {
            --entityDragonforge.getPropertyDelegate().cookTime;
        }
        if (entityDragonforge.getItem(0).isEmpty() && !level.isClientSide) {
            entityDragonforge.getPropertyDelegate().cookTime = 0;
        }
        assert (entityDragonforge.level != null);
        if (!entityDragonforge.level.isClientSide) {
            if (entityDragonforge.isBurning()) {
                if (entityDragonforge.canSmelt()) {
                    ++entityDragonforge.getPropertyDelegate().cookTime;
                    if (entityDragonforge.getPropertyDelegate().cookTime >= entityDragonforge.getMaxCookTime()) {
                        entityDragonforge.getPropertyDelegate().cookTime = 0;
                        entityDragonforge.smeltItem();
                        flag1 = true;
                    }
                } else if (entityDragonforge.getPropertyDelegate().cookTime > 0) {
                    entityDragonforge.lastDragonFlameTimer = 40;
                    entityDragonforge.getPropertyDelegate().cookTime = 0;
                }
            } else if (!entityDragonforge.isBurning() && entityDragonforge.getPropertyDelegate().cookTime > 0) {
                entityDragonforge.getPropertyDelegate().cookTime = Mth.clamp((int)(entityDragonforge.getPropertyDelegate().cookTime - 2), (int)0, (int)entityDragonforge.getMaxCookTime());
            }
            if (flag != entityDragonforge.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            entityDragonforge.setChanged();
        }
        if (!entityDragonforge.canAddFlameAgain) {
            entityDragonforge.canAddFlameAgain = true;
        }
    }

    public int getContainerSize() {
        return this.forgeItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.forgeItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void updateGrills(boolean grill) {
        for (Direction facing : HORIZONTALS) {
            BlockPos grillPos = this.getBlockPos().relative(facing);
            assert (this.level != null);
            if (!this.grillMatches(this.level.getBlockState(grillPos).getBlock())) continue;
            BlockState grillState = (BlockState)this.getGrillBlock().defaultBlockState().setValue((Property)BlockDragonForgeBricks.GRILL, (Comparable)Boolean.valueOf(grill));
            if (this.level.getBlockState(grillPos) == grillState) continue;
            this.level.setBlockAndUpdate(grillPos, grillState);
        }
    }

    public Block getGrillBlock() {
        return switch (this.getPropertyDelegate().fireType) {
            case 1 -> (Block)IafBlocks.DRAGONFORGE_ICE_BRICK.get();
            case 2 -> (Block)IafBlocks.DRAGONFORGE_LIGHTNING_BRICK.get();
            default -> (Block)IafBlocks.DRAGONFORGE_FIRE_BRICK.get();
        };
    }

    public boolean grillMatches(Block block) {
        return switch (this.getPropertyDelegate().fireType) {
            case 0 -> {
                if (block == IafBlocks.DRAGONFORGE_FIRE_BRICK.get()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (block == IafBlocks.DRAGONFORGE_ICE_BRICK.get()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (block == IafBlocks.DRAGONFORGE_LIGHTNING_BRICK.get()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.forgeItemStacks.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.forgeItemStacks, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.forgeItemStacks, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.forgeItemStacks.get(index);
        boolean flag = !stack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemstack) && ItemStack.matches((ItemStack)stack, (ItemStack)itemstack);
        this.forgeItemStacks.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (index == 0 && !flag || this.getPropertyDelegate().cookTime > this.getMaxCookTime()) {
            this.getPropertyDelegate().cookTime = 0;
            this.setChanged();
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.forgeItemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.forgeItemStacks, (HolderLookup.Provider)registryLookup);
        this.getPropertyDelegate().cookTime = nbt.getInt("CookTime");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("CookTime", (int)((short)this.getPropertyDelegate().cookTime));
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.forgeItemStacks, (HolderLookup.Provider)registryLookup);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean isBurning() {
        return this.getPropertyDelegate().cookTime > 0;
    }

    public int getFireType(Block block) {
        if (block == IafBlocks.DRAGONFORGE_FIRE_CORE.get() || block == IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()) {
            return 0;
        }
        if (block == IafBlocks.DRAGONFORGE_ICE_CORE.get() || block == IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()) {
            return 1;
        }
        if (block == IafBlocks.DRAGONFORGE_LIGHTNING_CORE.get() || block == IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()) {
            return 2;
        }
        return 0;
    }

    public int getMaxCookTime() {
        return this.getCurrentRecipe().map(DragonForgeRecipe::getCookTime).orElse(100);
    }

    private Block getDefaultOutput() {
        return this.getPropertyDelegate().fireType == 1 ? (Block)IafBlocks.DRAGON_ICE.get() : (Block)IafBlocks.ASH.get();
    }

    private ItemStack getCurrentResult() {
        Optional<DragonForgeRecipe> recipe = this.getCurrentRecipe();
        return recipe.map(DragonForgeRecipe::getResultItem).orElseGet(() -> new ItemStack((ItemLike)this.getDefaultOutput()));
    }

    public Optional<DragonForgeRecipe> getCurrentRecipe() {
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get(), (RecipeInput)new DragonForgeRecipeInput(this), this.level).map(RecipeHolder::value);
    }

    public List<DragonForgeRecipe> getRecipes() {
        assert (this.level != null);
        return this.level.getRecipeManager().getAllRecipesFor((RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get()).stream().map(RecipeHolder::value).toList();
    }

    public boolean canSmelt() {
        ItemStack cookStack = (ItemStack)this.forgeItemStacks.getFirst();
        if (cookStack.isEmpty()) {
            return false;
        }
        ItemStack forgeRecipeOutput = this.getCurrentResult();
        if (forgeRecipeOutput.isEmpty()) {
            return false;
        }
        ItemStack outputStack = (ItemStack)this.forgeItemStacks.get(2);
        if (!outputStack.isEmpty() && !ItemStack.isSameItem((ItemStack)outputStack, (ItemStack)forgeRecipeOutput)) {
            return false;
        }
        int calculatedOutputCount = outputStack.getCount() + forgeRecipeOutput.getCount();
        return calculatedOutputCount <= this.getMaxStackSize() && calculatedOutputCount <= outputStack.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        if (player.level().getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack cookStack = (ItemStack)this.forgeItemStacks.get(0);
        ItemStack bloodStack = (ItemStack)this.forgeItemStacks.get(1);
        ItemStack outputStack = (ItemStack)this.forgeItemStacks.get(2);
        ItemStack output = this.getCurrentResult();
        if (outputStack.isEmpty()) {
            this.forgeItemStacks.set(2, (Object)output.copy());
        } else {
            outputStack.grow(output.getCount());
        }
        cookStack.shrink(1);
        bloodStack.shrink(1);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return switch (index) {
            case 1 -> this.getRecipes().stream().anyMatch(item -> item.isValidBlood(stack));
            case 0 -> true;
            default -> false;
        };
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == Direction.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1) {
            Item item = stack.getItem();
            return item == Items.WATER_BUCKET || item == Items.BUCKET;
        }
        return true;
    }

    public void clearContent() {
        this.forgeItemStacks.clear();
    }

    protected Component getDefaultName() {
        return Component.translatable((String)("container.dragonforge_fire" + DragonType.getNameFromInt(this.getPropertyDelegate().fireType)));
    }

    protected NonNullList<ItemStack> getItems() {
        return this.forgeItemStacks;
    }

    protected void setItems(NonNullList<ItemStack> inventory) {
        this.forgeItemStacks = inventory;
    }

    public void transferPower(int i) {
        assert (this.level != null);
        if (!this.level.isClientSide) {
            if (this.canSmelt()) {
                if (this.canAddFlameAgain) {
                    this.getPropertyDelegate().cookTime = Math.min(this.getMaxCookTime() + 1, this.getPropertyDelegate().cookTime + i);
                    this.canAddFlameAgain = false;
                }
            } else {
                this.getPropertyDelegate().cookTime = 0;
            }
        }
        this.lastDragonFlameTimer = 40;
    }

    private boolean checkBoneCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.north().east(), (Block)IafBlocks.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.north().west(), (Block)IafBlocks.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.south().east(), (Block)IafBlocks.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.south().west(), (Block)IafBlocks.DRAGON_BONE_BLOCK.get());
    }

    private boolean checkBrickCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.north().east(), this.getBrick()) && this.doesBlockEqual(pos.north().west(), this.getBrick()) && this.doesBlockEqual(pos.south().east(), this.getBrick()) && this.doesBlockEqual(pos.south().west(), this.getBrick());
    }

    private boolean checkBrickSlots(BlockPos pos) {
        return this.doesBlockEqual(pos.north(), this.getBrick()) && this.doesBlockEqual(pos.east(), this.getBrick()) && this.doesBlockEqual(pos.west(), this.getBrick()) && this.doesBlockEqual(pos.south(), this.getBrick());
    }

    private boolean checkY(BlockPos pos) {
        return this.doesBlockEqual(pos.above(), this.getBrick()) && this.doesBlockEqual(pos.below(), this.getBrick());
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithFullMetadata(registryLookup);
    }

    public boolean assembled() {
        return this.checkBoneCorners(this.worldPosition.below()) && this.checkBrickSlots(this.worldPosition.below()) && this.checkBrickCorners(this.worldPosition) && this.atleastThreeAreBricks(this.worldPosition) && this.checkY(this.worldPosition) && this.checkBoneCorners(this.worldPosition.above()) && this.checkBrickSlots(this.worldPosition.above());
    }

    private Block getBrick() {
        return switch (this.getPropertyDelegate().fireType) {
            case 0 -> (Block)IafBlocks.DRAGONFORGE_FIRE_BRICK.get();
            case 1 -> (Block)IafBlocks.DRAGONFORGE_ICE_BRICK.get();
            default -> (Block)IafBlocks.DRAGONFORGE_LIGHTNING_BRICK.get();
        };
    }

    private boolean doesBlockEqual(BlockPos pos, Block block) {
        assert (this.level != null);
        return this.level.getBlockState(pos).getBlock() == block;
    }

    private boolean atleastThreeAreBricks(BlockPos pos) {
        int count = 0;
        for (Direction facing : HORIZONTALS) {
            assert (this.level != null);
            if (this.level.getBlockState(pos.relative(facing)).getBlock() != this.getBrick()) continue;
            ++count;
        }
        return count > 2;
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new DragonForgeScreenHandler(id, (Container)this, playerInventory, this.getPropertyDelegate());
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new DragonForgeScreenHandler(id, (Container)this, player, this.getPropertyDelegate());
    }

    public DragonForgePropertyDelegate getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public static class DragonForgeRecipeInput
    implements RecipeInput {
        private final BlockEntityDragonForge owner;

        public DragonForgeRecipeInput(BlockEntityDragonForge owner) {
            this.owner = owner;
        }

        public ItemStack getItem(int slot) {
            return (ItemStack)this.owner.forgeItemStacks.get(slot);
        }

        public int size() {
            return this.owner.forgeItemStacks.size();
        }

        public ItemStack getStack(int index) {
            return (ItemStack)this.owner.forgeItemStacks.get(index);
        }

        public String getTypeID() {
            return switch (this.owner.getFireType(this.owner.getBlockState().getBlock())) {
                case 0 -> "fire";
                case 1 -> "ice";
                case 2 -> "lightning";
                default -> "";
            };
        }
    }
}

