/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockLaunchExplosion
extends Explosion {
    private final float size;
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    private final Explosion.BlockInteraction mode;

    public BlockLaunchExplosion(Level world, Mob entity, double x, double y, double z, float size) {
        this(world, entity, x, y, z, size, Explosion.BlockInteraction.DESTROY);
    }

    public BlockLaunchExplosion(Level world, Mob entity, double x, double y, double z, float size, Explosion.BlockInteraction mode) {
        this(world, entity, null, x, y, z, size, mode);
    }

    public BlockLaunchExplosion(Level world, Mob entity, DamageSource source, double x, double y, double z, float size, Explosion.BlockInteraction mode) {
        super(world, (Entity)entity, source, null, x, y, z, size, false, mode, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
        this.world = world;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
    }

    private static void handleExplosionDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
        int i = dropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)dropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.areMergable((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.merge((ItemStack)itemstack, (ItemStack)stack, (int)16);
            dropPositionArray.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!stack.isEmpty()) continue;
            return;
        }
        dropPositionArray.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void finalizeExplosion(boolean spawnParticles) {
        boolean flag;
        if (this.world.isClientSide) {
            this.world.playLocalSound(this.x, this.y, this.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.world.random.nextFloat() - this.world.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Explosion.BlockInteraction.KEEP;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            Collections.shuffle(this.getToBlow(), ThreadLocalRandom.current());
            for (BlockPos blockpos : this.getToBlow()) {
                BlockState blockstate = this.world.getBlockState(blockpos);
                if (blockstate.isAir()) continue;
                BlockPos blockpos1 = blockpos.immutable();
                this.world.getProfiler().push("explosion_blocks");
                Vec3 Vector3d = new Vec3(this.x, this.y, this.z);
                this.world.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 3);
                blockstate.getBlock().wasExploded(this.world, blockpos, (Explosion)this);
                FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(EntityType.FALLING_BLOCK, this.world);
                fallingBlockEntity.setStartPos(blockpos1);
                fallingBlockEntity.setPos((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5);
                double d5 = fallingBlockEntity.getX() - this.x;
                double d7 = fallingBlockEntity.getEyeY() - this.y;
                double d9 = fallingBlockEntity.getZ() - this.z;
                float f3 = this.size * 2.0f;
                double d12 = Math.sqrt(fallingBlockEntity.distanceToSqr(Vector3d)) / (double)f3;
                double d14 = BlockLaunchExplosion.getSeenPercent((Vec3)Vector3d, (Entity)fallingBlockEntity);
                double d11 = (1.0 - d12) * d14;
                fallingBlockEntity.setDeltaMovement(fallingBlockEntity.getDeltaMovement().add(d5 * d11, d7 * d11, d9 * d11));
                this.world.getProfiler().pop();
            }
        }
    }
}

