/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.entity.EntityStymphalianFeather;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemStymphalianFeatherBundle
extends Item {
    public ItemStymphalianFeatherBundle() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand hand) {
        ItemStack itemStackIn = player.getItemInHand(hand);
        player.startUsingItem(hand);
        player.getCooldowns().addCooldown((Item)this, 15);
        player.playSound(SoundEvents.EGG_THROW, 1.0f, 1.0f);
        float rotation = player.yHeadRot;
        for (int i = 0; i < 8; ++i) {
            EntityStymphalianFeather feather = new EntityStymphalianFeather((EntityType<? extends AbstractArrow>)((EntityType)IafEntities.STYMPHALIAN_FEATHER.get()), worldIn, (LivingEntity)player);
            feather.shootFromRotation((Entity)player, 0.0f, rotation += 45.0f, 0.0f, 1.5f, 1.0f);
            if (worldIn.isClientSide) continue;
            worldIn.addFreshEntity((Entity)feather);
        }
        if (!player.isCreative()) {
            itemStackIn.shrink(1);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.stymphalian_feather_bundle.desc_0").withStyle(ChatFormatting.GRAY));
    }
}

