/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.iafenvoy.iceandfire.registry.IafArmorMaterials;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.client.render.armor.IArmorTextureProvider;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ItemModArmor
extends ArmorItem
implements IArmorTextureProvider {
    public ItemModArmor(Holder<ArmorMaterial> material, ArmorItem.Type slot, int maxDamage) {
        super(material, slot, new Item.Properties().durability(maxDamage));
    }

    public String getDescriptionId(ItemStack stack) {
        if (this == IafItems.EARPLUGS.get()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            if (calendar.get(2) + 1 == 4 && calendar.get(5) == 1) {
                return "item.iceandfire.air_pods";
            }
        }
        return super.getDescriptionId(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (this == IafItems.EARPLUGS.get()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            if (calendar.get(2) + 1 == 4 && calendar.get(5) == 1) {
                tooltip.add((Component)Component.translatable((String)"item.iceandfire.air_pods.desc").withStyle(ChatFormatting.GREEN));
            }
        }
    }

    public ResourceLocation getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlot equipmentSlot, ArmorMaterial.Layer layer, boolean b) {
        if (this.material.value() == IafArmorMaterials.SHEEP_ARMOR_MATERIAL.value()) {
            return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/armor/" + (equipmentSlot == EquipmentSlot.LEGS ? "sheep_disguise_layer_2" : "sheep_disguise_layer_1") + ".png"));
        }
        if (this.material.value() == IafArmorMaterials.EARPLUGS_ARMOR_MATERIAL.value()) {
            return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/armor/earplugs_layer_1.png");
        }
        return null;
    }
}

