/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeBrick;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDragonForgeBricks
extends BaseEntityBlock
implements IDragonProof {
    public static final BooleanProperty GRILL = BooleanProperty.create((String)"grill");
    private final int isFire;

    public BlockDragonForgeBricks(int isFire) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).dynamicShape().strength(40.0f, 500.0f).sound(SoundType.METAL));
        this.isFire = isFire;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GRILL, (Comparable)Boolean.FALSE));
    }

    public static String name(int dragonType) {
        return "dragonforge_%s_brick".formatted(DragonType.getNameFromInt(dragonType));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntityDragonForge forge;
        if (this.getConnectedTileEntity(world, pos) != null && (forge = this.getConnectedTileEntity(world, pos)) != null && forge.getPropertyDelegate().fireType == this.isFire) {
            MenuProvider inamedcontainerprovider;
            if (!world.isClientSide && (inamedcontainerprovider = this.getMenuProvider(forge.getBlockState(), world, forge.getBlockPos())) != null) {
                player.openMenu(inamedcontainerprovider);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private BlockEntityDragonForge getConnectedTileEntity(Level worldIn, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockEntityDragonForge forge;
            BlockEntity blockEntity;
            if (worldIn.getBlockEntity(pos.relative(facing)) == null || !((blockEntity = worldIn.getBlockEntity(pos.relative(facing))) instanceof BlockEntityDragonForge) || !(forge = (BlockEntityDragonForge)blockEntity).assembled()) continue;
            return forge;
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GRILL});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MapCodec.unit((Object)this);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityDragonForgeBrick(pos, state);
    }
}

