/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeInput;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDragonForgeInput
extends BaseEntityBlock
implements IDragonProof {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private final int dragonType;

    public BlockDragonForgeInput(int dragonType) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).dynamicShape().strength(40.0f, 500.0f).sound(SoundType.METAL));
        this.dragonType = dragonType;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.FALSE));
    }

    public static String name(int dragonType) {
        return "dragonforge_%s_input".formatted(DragonType.getNameFromInt(dragonType));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntityDragonForge forge;
        if (this.getConnectedTileEntity(world, pos) != null && (forge = this.getConnectedTileEntity(world, pos)) != null && forge.getPropertyDelegate().fireType == this.dragonType) {
            MenuProvider inamedcontainerprovider;
            if (!world.isClientSide && (inamedcontainerprovider = this.getMenuProvider(forge.getBlockState(), world, forge.getBlockPos())) != null) {
                player.openMenu(inamedcontainerprovider);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private BlockEntityDragonForge getConnectedTileEntity(Level world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            if (world.getBlockEntity(pos.relative(facing)) == null || !(world.getBlockEntity(pos.relative(facing)) instanceof BlockEntityDragonForge)) continue;
            return (BlockEntityDragonForge)world.getBlockEntity(pos.relative(facing));
        }
        return null;
    }

    public BlockState getStateFromMeta(int meta) {
        return (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(meta > 0));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getMetaFromState(BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? 1 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return world.isClientSide ? null : BlockDragonForgeInput.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.DRAGONFORGE_INPUT.get()), BlockEntityDragonForgeInput::tick);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityDragonForgeInput(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MapCodec.unit((Object)this);
    }
}

