/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.entity.EntityDreadMob;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class BlockGeneric
extends Block {
    public BlockGeneric(BlockBehaviour.Properties props) {
        super(props);
    }

    public static BlockGeneric builder(float hardness, float resistance, SoundType sound, MapColor color, NoteBlockInstrument instrument, PushReaction reaction, boolean ignited) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.of().mapColor(color).sound(sound).strength(hardness, resistance).requiresCorrectToolForDrops();
        if (instrument != null) {
            props.instrument(instrument);
        }
        if (reaction != null) {
            props.pushReaction(reaction);
        }
        if (ignited) {
            props.ignitedByLava();
        }
        return new BlockGeneric(props);
    }

    public static BlockGeneric builder(float hardness, float resistance, SoundType sound, boolean slippery, MapColor color, NoteBlockInstrument instrument, PushReaction reaction, boolean ignited) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.of().mapColor(color).sound(sound).strength(hardness, resistance).friction(0.98f);
        if (instrument != null) {
            props.instrument(instrument);
        }
        if (reaction != null) {
            props.pushReaction(reaction);
        }
        if (ignited) {
            props.ignitedByLava();
        }
        return new BlockGeneric(props);
    }

    @Deprecated
    public boolean canEntitySpawn(BlockState state, Entity entity) {
        return entity instanceof EntityDreadMob || !DragonUtils.isDreadBlock(state);
    }
}

