/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.entity.block.BlockEntityJar;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockJar
extends BaseEntityBlock {
    private static final MapCodec<? extends BaseEntityBlock> CODEC = BlockJar.simpleCodec(s -> new BlockJar(-1));
    protected static final VoxelShape AABB = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private final boolean empty;
    private final int pixieType;

    public BlockJar(int pixieType) {
        super(pixieType != -1 ? BlockBehaviour.Properties.of().mapColor(MapColor.NONE).instrument(NoteBlockInstrument.HAT).noOcclusion().dynamicShape().strength(1.0f, 2.0f).sound(SoundType.GLASS).lightLevel(state -> 10).dropsLike((Block)IafBlocks.JAR_EMPTY.get()) : BlockBehaviour.Properties.of().mapColor(MapColor.NONE).instrument(NoteBlockInstrument.HAT).noOcclusion().dynamicShape().strength(1.0f, 2.0f).sound(SoundType.GLASS));
        this.empty = pixieType == -1;
        this.pixieType = pixieType;
    }

    public static String name(int pixieType) {
        if (pixieType == -1) {
            return "pixie_jar_empty";
        }
        return "pixie_jar_%d".formatted(pixieType);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropPixie(worldIn, pos);
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void dropPixie(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (world.getBlockEntity(pos) != null && (blockEntity = world.getBlockEntity(pos)) instanceof BlockEntityJar) {
            BlockEntityJar jar = (BlockEntityJar)blockEntity;
            if (jar.hasPixie) {
                jar.releasePixie();
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!this.empty && world.getBlockEntity(pos) != null && (blockEntity = world.getBlockEntity(pos)) instanceof BlockEntityJar) {
            BlockEntityJar jar = (BlockEntityJar)blockEntity;
            if (jar.hasPixie && jar.hasProduced) {
                jar.hasProduced = false;
                ItemEntity item = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)IafItems.PIXIE_DUST.get()));
                if (!world.isClientSide) {
                    world.addFreshEntity((Entity)item);
                }
                world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)IafSounds.PIXIE_HURT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlockEntityJar) {
            BlockEntityJar jar = (BlockEntityJar)blockEntity;
            if (!this.empty) {
                jar.hasPixie = true;
                jar.pixieType = this.pixieType;
            } else {
                jar.hasPixie = false;
            }
            jar.setChanged();
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockJar.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_JAR.get()), BlockEntityJar::tick);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityJar(pos, state, this.empty);
    }

    public int getPixieType() {
        return this.pixieType;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

