/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.entity.block.BlockEntityPixieHouse;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class BlockPixieHouse
extends BaseEntityBlock {
    private static final MapCodec<? extends BaseEntityBlock> CODEC = BlockPixieHouse.simpleCodec(s -> new BlockPixieHouse());
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    public BlockPixieHouse() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).ignitedByLava().noOcclusion().dynamicShape().strength(2.0f, 5.0f).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static String name(String type) {
        return "pixie_house_%s".formatted(type);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropPixie(worldIn, pos);
        BlockPixieHouse.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this, 0));
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void dropPixie(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (world.getBlockEntity(pos) != null && (blockEntity = world.getBlockEntity(pos)) instanceof BlockEntityPixieHouse) {
            BlockEntityPixieHouse house = (BlockEntityPixieHouse)blockEntity;
            if (house.hasPixie) {
                house.releasePixie();
            }
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        return level.isClientSide ? BlockPixieHouse.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_HOUSE.get()), BlockEntityPixieHouse::tickClient) : BlockPixieHouse.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_HOUSE.get()), BlockEntityPixieHouse::tickServer);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityPixieHouse(pos, state);
    }
}

