/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.neoforge.compat;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

@RecipeTypeMapper(requiredMods={"iceandfire"}, priority=1)
public class ProjectEDragonForgeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "IceAndFireDragonForgeMapper";
    }

    public String getTranslationKey() {
        return "projecte.iceandfire.dragon_forge";
    }

    public String getDescription() {
        return "Recipe mapper for Ice and Fire DragonForge recipes";
    }

    public boolean canHandle(RecipeType<?> recipeType) {
        return recipeType == IafRecipes.DRAGON_FORGE_TYPE.get();
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> collector, RecipeHolder<?> entry, RegistryAccess registryManager, INSSFakeGroupManager inssFakeGroupManager) {
        Recipe recipe = entry.value();
        if (recipe instanceof DragonForgeRecipe) {
            DragonForgeRecipe recipe2 = (DragonForgeRecipe)recipe;
            ItemStack output = recipe2.getResultItem();
            if (output == null || output.isEmpty()) {
                return false;
            }
            boolean successful = true;
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            Object2IntLinkedOpenHashMap ingredientMap = new Object2IntLinkedOpenHashMap();
            for (Ingredient ingredient : List.of(recipe2.getInput(), recipe2.getBlood())) {
                if (ProjectEDragonForgeMapper.convertIngredient(ingredient, (Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, inssFakeGroupManager, entry.id().toString())) continue;
                successful = false;
                break;
            }
            if (successful) {
                collector.addConversion(output.getCount(), (Object)NSSItem.createItem((ItemStack)output), (Object2IntMap)ingredientMap);
            }
            for (Tuple tuple : fakeGroupMap) {
                for (Object2IntMap groupObject2IntMap : (List)tuple.getB()) {
                    collector.addConversion(1, (Object)((NormalizedSimpleStack)tuple.getA()), groupObject2IntMap);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean convertIngredient(Ingredient ingredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap, INSSFakeGroupManager fakeGroupManager, String recipeID) {
        ItemStack[] matches = ingredient.getItems();
        if (matches == null) {
            return false;
        }
        if (matches.length == 1) {
            return !ProjectEDragonForgeMapper.addIngredient(ingredientMap, matches[0].copy());
        }
        if (matches.length > 0) {
            HashSet<NSSItem> rawNSSMatches = new HashSet<NSSItem>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack match : matches) {
                if (match.isEmpty()) continue;
                rawNSSMatches.add(NSSItem.createItem((ItemStack)match));
                stacks.add(match);
            }
            int count = stacks.size();
            if (count == 1) {
                ItemStack item = (ItemStack)stacks.getFirst();
                return !ProjectEDragonForgeMapper.addIngredient(ingredientMap, item.copy());
            }
            if (count > 1) {
                INSSFakeGroupManager.FakeGroupData group = fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = group.dummy();
                ingredientMap.put((Object)dummy, Math.max(-1, 1));
                if (group.created()) {
                    ArrayList<Object2IntLinkedOpenHashMap> groupIngredientMaps = new ArrayList<Object2IntLinkedOpenHashMap>();
                    Iterator iterator = stacks.iterator();
                    while (iterator.hasNext()) {
                        Object2IntLinkedOpenHashMap groupIngredientMap = new Object2IntLinkedOpenHashMap();
                        ItemStack stack = (ItemStack)iterator.next();
                        if (ProjectEDragonForgeMapper.addIngredient((Object2IntMap<NormalizedSimpleStack>)groupIngredientMap, stack.copy())) {
                            return false;
                        }
                        groupIngredientMaps.add(groupIngredientMap);
                    }
                    fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                }
            }
        }
        return true;
    }

    public static boolean addIngredient(Object2IntMap<NormalizedSimpleStack> ingredientMap, ItemStack stack) {
        Item item = stack.getItem();
        try {
            if (item.hasCraftingRemainingItem(stack)) {
                ingredientMap.put((Object)NSSItem.createItem((ItemStack)item.getCraftingRemainingItem(stack)), -1);
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error("Failed to mapping recipe", (Throwable)e);
            return true;
        }
        ingredientMap.put((Object)NSSItem.createItem((ItemStack)stack), stack.getCount());
        return false;
    }
}

