/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.particle;

import com.iafenvoy.iceandfire.particle.DragonFlameParticleType;
import com.iafenvoy.uranus.object.VecUtil;
import com.iafenvoy.uranus.util.RandomHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ParticleDragonFlame
extends TextureSheetParticle {
    public ParticleDragonFlame(DragonFlameParticleType params, ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, SpriteSet provider) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        float size = params.getScale();
        this.quadSize *= (float)RandomHelper.nextDouble((double)size, (double)(size * 2.0f));
        this.lifetime = 30;
        this.gravity = 0.0f;
        this.hasPhysics = false;
        this.pickSprite(provider);
        this.setParticleSpeed(RandomHelper.randomize((double)xSpeedIn, (double)0.5), RandomHelper.randomize((double)ySpeedIn, (double)0.5), RandomHelper.randomize((double)zSpeedIn, (double)0.5));
    }

    public static Provider provider(SpriteSet spriteSet) {
        return new Provider(spriteSet);
    }

    public int getLightColor(float partialTick) {
        return 240;
    }

    public void tick() {
        super.tick();
        BlockState state = this.level.getBlockState(VecUtil.createBlockPos((double)this.x, (double)this.y, (double)this.z));
        if (state != null && state.isSolid()) {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public record Provider(SpriteSet spriteSet) implements ParticleProvider<DragonFlameParticleType>
    {
        public Particle createParticle(DragonFlameParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleDragonFlame(typeIn, worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

