/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.IceAndFire;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RenderChain {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/misc/chain_link.png");

    public static void render(LivingEntity entityLivingIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int lightIn, List<Entity> chainedTo) {
        for (Entity chainTarget : chainedTo) {
            if (chainTarget == null) {
                IceAndFire.LOGGER.warn("Found null value in list of target entities");
                continue;
            }
            try {
                RenderChain.renderLink(entityLivingIn, matrixStackIn, bufferIn, lightIn, chainTarget);
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Could not render chain link for {} connected to {}", (Object)entityLivingIn.toString(), (Object)chainTarget.toString());
            }
        }
    }

    public static <E extends Entity> void renderLink(LivingEntity entityLivingIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int lightIn, E chainTarget) {
        float f3 = entityLivingIn.getBbHeight() * 0.4f;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, (double)f3, 0.0);
        Vec3 vector3d = RenderChain.getPosition(chainTarget, (double)chainTarget.getBbHeight() * 0.5);
        Vec3 vector3d1 = RenderChain.getPosition((Entity)entityLivingIn, f3);
        Vec3 vector3d2 = vector3d.subtract(vector3d1);
        float f4 = (float)(vector3d2.length() + 0.0);
        vector3d2 = vector3d2.normalize();
        float f5 = (float)Math.acos(vector3d2.y);
        float f6 = (float)Math.atan2(vector3d2.z, vector3d2.x);
        matrixStackIn.mulPose(Axis.YP.rotation(1.5707964f - f6));
        matrixStackIn.mulPose(Axis.XP.rotation(f5));
        float f7 = -1.0f;
        int j = 255;
        int k = 255;
        int l = 255;
        float f19 = 0.0f;
        float f20 = 0.2f;
        float f21 = 0.0f;
        float f22 = -0.2f;
        float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
        float f29 = 0.0f;
        float f30 = f4 + f29;
        float f32 = 0.75f;
        float f31 = f4 + f32;
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)RenderChain.getTexture()));
        PoseStack.Pose entry = matrixStackIn.last();
        Matrix4f matrix4f = entry.pose();
        matrixStackIn.pushPose();
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f19, f4, f20, j, k, l, 0.4999f, f30, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f19, 0.0f, f20, j, k, l, 0.4999f, f29, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f21, 0.0f, f22, j, k, l, 0.0f, f29, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f21, f4, f22, j, k, l, 0.0f, f30, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f23, f4, f24, j, k, l, 0.4999f, f31, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f23, 0.0f, f24, j, k, l, 0.4999f, f32, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f25, 0.0f, f26, j, k, l, 0.0f, f32, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, entry, f25, f4, f26, j, k, l, 0.0f, f31, lightIn);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }

    private static void vertex(VertexConsumer consumer, Matrix4f matrix4f, PoseStack.Pose entry, float x, float y, float z, int r, int g, int b, float u, float v, int packedLight) {
        consumer.addVertex(matrix4f, x, y, z).setColor(r, g, b, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(entry, 0.0f, 1.0f, 0.0f);
    }

    private static Vec3 getPosition(Entity LivingEntityIn, double p_177110_2_) {
        return LivingEntityIn.position().add(0.0, p_177110_2_, 0.0);
    }

    public static ResourceLocation getTexture() {
        return TEXTURE;
    }
}

