/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.render.entity.layer.LayerGorgonEyes;
import com.iafenvoy.iceandfire.render.model.ModelGorgon;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class RenderGorgon
extends MobRenderer<EntityGorgon, ModelGorgon> {
    public static final ResourceLocation PASSIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/gorgon/gorgon_passive.png");
    public static final ResourceLocation AGRESSIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/gorgon/gorgon_active.png");
    public static final ResourceLocation DEAD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/gorgon/gorgon_decapitated.png");

    public RenderGorgon(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelGorgon(), 0.4f);
        this.layers.add(new LayerGorgonEyes(this));
    }

    public void scale(EntityGorgon LivingEntityIn, PoseStack stack, float partialTickTime) {
        stack.scale(0.85f, 0.85f, 0.85f);
    }

    public ResourceLocation getTexture(EntityGorgon gorgon) {
        if (gorgon.getAnimation() == EntityGorgon.ANIMATION_SCARE) {
            return AGRESSIVE_TEXTURE;
        }
        if (gorgon.deathTime > 0) {
            return DEAD_TEXTURE;
        }
        return PASSIVE_TEXTURE;
    }
}

