/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.iafenvoy.iceandfire.screen.handler.DragonForgeScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public class DragonForgeScreen
extends AbstractContainerScreen<DragonForgeScreenHandler> {
    private static final ResourceLocation TEXTURE_FIRE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/dragonforge_fire.png");
    private static final ResourceLocation TEXTURE_ICE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/dragonforge_ice.png");
    private static final ResourceLocation TEXTURE_LIGHTNING = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/dragonforge_lightning.png");
    private final DragonForgeScreenHandler tileFurnace;

    public DragonForgeScreen(DragonForgeScreenHandler container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tileFurnace = container;
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        assert (this.minecraft != null);
        Font textRenderer = this.minecraft.font;
        if (this.tileFurnace != null) {
            String s = I18n.get((String)("block.iceandfire.dragonforge_" + DragonType.getNameFromInt(this.tileFurnace.getPropertyDelegate().fireType) + "_core"), (Object[])new Object[0]);
            pGuiGraphics.drawString(this.font, s, this.imageWidth / 2 - textRenderer.width(s) / 2, 6, 0x404040, false);
        }
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int dragonType = this.tileFurnace.getPropertyDelegate().fireType;
        ResourceLocation texture = switch (dragonType) {
            case 0 -> TEXTURE_FIRE;
            case 1 -> TEXTURE_ICE;
            default -> TEXTURE_LIGHTNING;
        };
        int k = (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(texture, k, l, 0, 0, this.imageWidth, this.imageHeight);
        int i1 = this.getCookTime(this.tileFurnace.getPropertyDelegate().cookTime);
        pGuiGraphics.blit(texture, k + 12, l + 23, 0, 166, i1, 38);
    }

    private int getCookTime(int time) {
        assert (this.minecraft != null);
        assert (this.minecraft.level != null);
        List<RecipeHolder> recipes = this.minecraft.level.getRecipeManager().getAllRecipesFor((RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get()).stream().filter(item -> ((DragonForgeRecipe)item.value()).isValidInput(this.tileFurnace.getSlot(0).getItem()) && ((DragonForgeRecipe)item.value()).isValidBlood(this.tileFurnace.getSlot(1).getItem())).toList();
        int maxCookTime = recipes.isEmpty() ? 100 : ((DragonForgeRecipe)recipes.getFirst().value()).getCookTime();
        double scale = 125000.0 / (double)maxCookTime;
        return (int)(scale * (double)time / (double)maxCookTime);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(context, mouseX, mouseY, partialTicks);
        super.render(context, mouseX, mouseY, partialTicks);
        this.renderTooltip(context, mouseX, mouseY);
    }
}

