/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SpawnDeathWorm
extends Feature<NoneFeatureConfiguration> {
    public SpawnDeathWorm(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.level();
        RandomSource rand = context.random();
        BlockPos position = context.origin();
        if (GenerationConstants.isFarEnoughFromSpawn(position = worldIn.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, position.offset(8, 0, 8))) && rand.nextDouble() < (Double)IafCommonConfig.INSTANCE.deathworm.spawnChance.getValue()) {
            EntityDeathWorm deathWorm = (EntityDeathWorm)((EntityType)IafEntities.DEATH_WORM.get()).create((Level)worldIn.getLevel());
            assert (deathWorm != null);
            deathWorm.setPos((float)position.getX() + 0.5f, position.getY() + 1, (float)position.getZ() + 0.5f);
            deathWorm.finalizeSpawn((ServerLevelAccessor)worldIn, worldIn.getCurrentDifficultyAt(position), MobSpawnType.CHUNK_GENERATION, null);
            worldIn.addFreshEntity((Entity)deathWorm);
        }
        return true;
    }
}

