/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityStymphalianBird;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SpawnStymphalianBird
extends Feature<NoneFeatureConfiguration> {
    public SpawnStymphalianBird(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.level();
        RandomSource rand = context.random();
        BlockPos position = context.origin();
        if (GenerationConstants.isFarEnoughFromSpawn(position = worldIn.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, position.offset(8, 0, 8))) && rand.nextDouble() < (Double)IafCommonConfig.INSTANCE.stymphalianBird.spawnChance.getValue()) {
            for (int i = 0; i < 4 + rand.nextInt(4); ++i) {
                BlockPos pos = position.offset(rand.nextInt(10) - 5, 0, rand.nextInt(10) - 5);
                if (!worldIn.getBlockState((pos = worldIn.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos)).below()).canOcclude()) continue;
                EntityStymphalianBird bird = (EntityStymphalianBird)((EntityType)IafEntities.STYMPHALIAN_BIRD.get()).create((Level)worldIn.getLevel());
                assert (bird != null);
                bird.moveTo((float)pos.getX() + 0.5f, (float)pos.getY() + 1.5f, (float)pos.getZ() + 0.5f, 0.0f, 0.0f);
                worldIn.addFreshEntity((Entity)bird);
            }
        }
        return true;
    }
}

