/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;

@OnlyIn(value=Dist.CLIENT)
public class AchievementCollectButton
extends AdvancedButton {
    private final AdvancementRewards advancementRewards;
    private final IInfoBook infoBook;

    public AchievementCollectButton(AdvancementRewards advancementRewards, IInfoBook infoBook) {
        this.advancementRewards = advancementRewards;
        this.infoBook = infoBook;
    }

    protected IInfoBook getInfoBook() {
        return this.infoBook;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
        super.renderTooltip(guiGraphics, font, mx, my);
        guiGraphics.pose().pushPose();
        if (mx >= this.getX() && my >= this.getY() && mx <= this.getX() + this.width && my <= this.getY() + this.height) {
            ArrayList lines = Lists.newArrayList();
            if (this.advancementRewards.isObtained((Player)Minecraft.getInstance().player)) {
                lines.add(FormattedCharSequence.forward((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collected", new Object[0]), (Style)Style.EMPTY.withItalic(Boolean.valueOf(true))));
            } else {
                lines.add(FormattedCharSequence.forward((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collect", new Object[0]), (Style)Style.EMPTY.withBold(Boolean.valueOf(true))));
                boolean canObtain = true;
                for (IReward reward : this.advancementRewards.getRewards()) {
                    if (reward.canObtain((Player)Minecraft.getInstance().player)) continue;
                    canObtain = false;
                }
                if (!canObtain) {
                    lines.add(FormattedCharSequence.forward((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collectFailure", new Object[0]), (Style)Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED))));
                }
            }
            guiGraphics.renderTooltip(font, (List)lines, mx, my);
        }
        guiGraphics.pose().popPose();
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onPress() {
        super.onPress();
        LocalPlayer player = Minecraft.getInstance().player;
        boolean canObtain = true;
        for (ResourceLocation advancement : this.advancementRewards.getAdvancements()) {
            if (AdvancementHelpers.hasAdvancementUnlocked((Player)Minecraft.getInstance().player, advancement)) continue;
            canObtain = false;
        }
        for (IReward reward : this.advancementRewards.getRewards()) {
            if (reward.canObtain((Player)player)) continue;
            canObtain = false;
        }
        if (canObtain) {
            this.advancementRewards.obtain((Player)player);
        }
    }

    @Override
    public void update(int x, int y, Component displayName, InfoSection target, ScreenInfoBook gui) {
        super.update(x, y, displayName, target, gui);
        this.width = 80;
    }
}

