/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.lwjgl.opengl.GL11;

public abstract class RecipeAppendix<T extends Recipe<?>>
extends SectionAppendix {
    protected static final int SLOT_SIZE = 16;
    protected static final int TICK_DELAY = 30;
    protected RecipeHolder<? extends T> recipe;
    protected Map<AdvancedButtonEnum, AdvancedButton> renderItemHolders = Maps.newHashMap();

    public RecipeAppendix(IInfoBook infoBook, RecipeHolder<? extends T> recipe) {
        super(infoBook);
        this.recipe = recipe;
    }

    protected int getTick(ScreenInfoBook gui) {
        return gui.getTick() / 30;
    }

    protected ItemStack prepareItemStacks(ItemStack[] itemStacks, int tick) {
        return this.prepareItemStacks(Arrays.asList(itemStacks), tick);
    }

    protected ItemStack prepareItemStacks(List<ItemStack> itemStacks, int tick) {
        if (itemStacks.size() == 0) {
            return ItemStack.EMPTY;
        }
        return this.prepareItemStack(itemStacks.get(tick % itemStacks.size()).copy(), tick);
    }

    protected ItemStack prepareItemStack(ItemStack itemStack, int tick) {
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, guiGraphics, x, y, itemStack, mx, my, buttonEnum, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, guiGraphics, x, y, itemStack, mx, my, renderOverlays, buttonEnum, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum, float chance) {
        this.renderItem(gui, guiGraphics, x, y, itemStack, mx, my, true, buttonEnum, chance);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum, float chance) {
        RecipeAppendix.renderItemForButton(gui, guiGraphics, x, y, itemStack, mx, my, renderOverlays, buttonEnum != null ? (ItemButton)this.renderItemHolders.get(buttonEnum) : null, chance);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForButton(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button) {
        RecipeAppendix.renderItemForButton(gui, guiGraphics, x, y, itemStack, mx, my, renderOverlays, button, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForButton(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button, float chance) {
        if (renderOverlays) {
            gui.drawOuterBorder(guiGraphics, x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (!itemStack.isEmpty()) {
            ItemRenderer renderItem = Minecraft.getInstance().getItemRenderer();
            guiGraphics.pose().pushPose();
            GlStateManager._enableBlend();
            GlStateManager._blendFunc((int)770, (int)771);
            Lighting.setupFor3DItems();
            GL11.glEnable((int)2929);
            guiGraphics.renderItem(itemStack, x, y);
            if (renderOverlays) {
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, itemStack, x, y);
            }
            Lighting.setupForFlatItems();
            guiGraphics.pose().popPose();
            GL11.glDisable((int)2929);
            if (chance != 1.0f) {
                String chanceString = chance * 100.0f + "%";
                gui.drawScaledCenteredString(guiGraphics, chanceString, x - 4, y + 3, gui.getFont().width(chanceString), 1.0f, 18, Helpers.RGBToInt(255, 255, 255), true);
            }
            if (button != null && renderOverlays) {
                button.update(x, y, itemStack, gui);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderFluid(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderFluid(gui, guiGraphics, x, y, fluidStack, mx, my, true, buttonEnum);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderFluid(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        RecipeAppendix.renderFluidForButton(gui, guiGraphics, x, y, fluidStack, mx, my, renderOverlays, buttonEnum != null ? (FluidButton)this.renderItemHolders.get(buttonEnum) : null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidForButton(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, FluidButton button) {
        if (renderOverlays) {
            gui.drawOuterBorder(guiGraphics, x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (!fluidStack.isEmpty()) {
            GuiHelpers.renderFluidSlot(guiGraphics, fluidStack, x, y);
            if (button != null && renderOverlays) {
                button.update(x, y, fluidStack, gui);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemTooltip(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my) {
        guiGraphics.pose().pushPose();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && !itemStack.isEmpty()) {
            gui.renderTooltip(guiGraphics, itemStack, mx, my);
        }
        guiGraphics.pose().popPose();
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidTooltip(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my) {
        guiGraphics.pose().pushPose();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && !fluidStack.isEmpty()) {
            ArrayList lines = Lists.newArrayList();
            lines.add(fluidStack.getHoverName().copy().withColor(TextColor.fromLegacyFormat((ChatFormatting)fluidStack.getFluid().getFluidType().getRarity(fluidStack).color()).getValue()).getVisualOrderText());
            lines.add(FormattedCharSequence.forward((String)(fluidStack.getAmount() + " mB"), (Style)Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY))));
            guiGraphics.renderTooltip(gui.getFont(), (List)lines, mx, my);
        }
        guiGraphics.pose().popPose();
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }

    @Override
    protected int getHeight() {
        return this.getHeightInner() + this.getAdditionalHeight();
    }

    protected abstract int getHeightInner();

    protected int getAdditionalHeight() {
        return 5;
    }

    @Override
    protected int getOffsetY() {
        return this.getAdditionalHeight();
    }

    protected abstract String getUnlocalizedTitle();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = this.getAdditionalHeight();
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(guiGraphics, L10NHelpers.localize(this.getUnlocalizedTitle(), new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, gui.getTitleColor());
        this.drawElementInner(gui, guiGraphics, x, y, width, height, page, mx, my);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(guiGraphics, gui.getFont(), mx, my);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void drawElementInner(ScreenInfoBook var1, GuiGraphics var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    @OnlyIn(value=Dist.CLIENT)
    protected void renderToolTips(GuiGraphics guiGraphics, Font font, int mx, int my) {
        for (AdvancedButton renderItemHolder : this.renderItemHolders.values()) {
            renderItemHolder.renderTooltip(guiGraphics, font, mx, my);
        }
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderItemHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        infoSection.addAdvancedButtons(this.getPage(), this.renderItemHolders.values());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemButton
    extends ElementButton<ItemStack> {
        public ItemButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        public void update(int x, int y, ItemStack element, ScreenInfoBook gui) {
            super.update(x, y, element.isEmpty() ? null : element, gui);
        }

        @Override
        public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
            RecipeAppendix.renderItemTooltip(this.gui, guiGraphics, this.getX(), this.getY(), (ItemStack)this.getElement(), mx, my);
        }

        @Override
        protected String getTranslationKey(ItemStack element) {
            return element.getDescriptionId();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FluidButton
    extends ElementButton<FluidStack> {
        public FluidButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        protected String getTranslationKey(FluidStack element) {
            return element.getTranslationKey();
        }

        @Override
        public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
            RecipeAppendix.renderFluidTooltip(this.gui, guiGraphics, this.getX(), this.getY(), (FluidStack)this.getElement(), mx, my);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ElementButton<E>
    extends AdvancedButton {
        private final IInfoBook infoBook;
        private E element;

        public ElementButton(IInfoBook infoBook) {
            this.infoBook = infoBook;
        }

        public E getElement() {
            return this.element;
        }

        public void update(int x, int y, E element, ScreenInfoBook gui) {
            this.element = element;
            InfoSection target = null;
            if (this.element != null) {
                String translationKey = this.getTranslationKey(element);
                Pair<InfoSection, Integer> pair = this.infoBook.getConfigLinks().get(translationKey);
                if (pair != null) {
                    target = (InfoSection)pair.getLeft();
                }
            }
            super.update(x, y, (Component)Component.literal((String)"empty"), target, gui);
        }

        protected abstract String getTranslationKey(E var1);

        @Override
        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.isVisible() && this.isHover(mouseX, mouseY)) {
                this.gui.drawOuterBorder(guiGraphics, this.getX(), this.getY(), 16, 16, 0.392f, 0.392f, 0.6f, 0.9f);
            }
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.element != null;
        }
    }
}

