/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public class NBTProviderComponent
implements INBTProvider {
    private final INBTProvider provider;
    private List<Field> nbtPersistedFields = null;

    public NBTProviderComponent(INBTProvider provider) {
        this.provider = provider;
        this.generateNBTPersistedFields();
    }

    private void generateNBTPersistedFields() {
        this.nbtPersistedFields = new LinkedList<Field>();
        for (Class<?> clazz = this.provider.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(NBTPersist.class)) continue;
                this.nbtPersistedFields.add(field);
            }
        }
    }

    private void writePersistedField(Field field, CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        NBTClassType.performActionForField(this.provider, field, tag, true, holderLookupProvider);
    }

    private void readPersistedField(Field field, CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        NBTClassType.performActionForField(this.provider, field, tag, false, holderLookupProvider);
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        for (Field field : this.nbtPersistedFields) {
            this.writePersistedField(field, tag, holderLookupProvider);
        }
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        for (Field field : this.nbtPersistedFields) {
            this.readPersistedField(field, tag, holderLookupProvider);
        }
    }
}

