/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.block;

import com.mojang.serialization.MapCodec;
import dev.satherov.crystalix.common.block.SLBlock;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.core.CSRegistry;
import dev.satherov.crystalix.core.annotations.NothingNull;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

@NothingNull
public class CrystalixGlass
extends SLBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<WaterloggedTransparentBlock> CODEC = CrystalixGlass.simpleCodec(WaterloggedTransparentBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty WATERLOGGABLE = BooleanProperty.create((String)"waterloggable");
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");
    public static final BooleanProperty SHADELESS = BooleanProperty.create((String)"shadeless");
    public static final BooleanProperty REINFORCED = BooleanProperty.create((String)"reinforced");
    public static final EnumProperty<CSProperties.Light> LIGHT = EnumProperty.create((String)"light", CSProperties.Light.class);
    public static final EnumProperty<CSProperties.Ghost> GHOST = EnumProperty.create((String)"ghost", CSProperties.Ghost.class);
    private final CSRegistry.Types type;
    private final CSRegistry.Colors color;

    public CrystalixGlass(CSRegistry.Types type, CSRegistry.Colors color) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS).mapColor(color.map()));
        this.type = type;
        this.color = color;
    }

    protected MapCodec<? extends WaterloggedTransparentBlock> codec() {
        return CODEC;
    }

    @Override
    protected void registerState(SLBlock.StateBuilder builder) {
        builder.addValue(WATERLOGGED, false);
        builder.addValue(WATERLOGGABLE, false);
        builder.addValue(INVISIBLE, false);
        builder.addValue(SHADELESS, false);
        builder.addValue(REINFORCED, false);
        builder.addValue(LIGHT, CSProperties.Light.NONE);
        builder.addValue(GHOST, CSProperties.Ghost.BLOCK_ALL);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Player player = context.getPlayer();
        BlockState state = this.defaultBlockState();
        if (player == null) {
            return state;
        }
        Level level = context.getLevel();
        FluidState fluidState = level.getFluidState(context.getClickedPos());
        state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is((Fluid)Fluids.WATER)));
        if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof CrystalixWand) {
            return this.fromStack(state, player.getItemInHand(InteractionHand.OFF_HAND));
        }
        return state;
    }

    public Integer getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this.color.color();
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(state);
    }

    public boolean canPlaceLiquid(@javax.annotation.Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)WATERLOGGABLE) != false && fluid == Fluids.WATER;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)WATERLOGGABLE)).booleanValue()) {
            return false;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() || fluidState.getType() != Fluids.WATER) {
            return false;
        }
        if (!level.isClientSide()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
        }
        return true;
    }

    protected VoxelShape getVisualShape(BlockState p_309057_, BlockGetter p_308936_, BlockPos p_308956_, CollisionContext p_309006_) {
        return Shapes.empty();
    }

    protected float getShadeBrightness(BlockState p_308911_, BlockGetter p_308952_, BlockPos p_308918_) {
        return 1.0f;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)INVISIBLE) != false ? RenderShape.INVISIBLE : super.getRenderShape(state);
    }

    protected boolean skipRendering(BlockState state, BlockState adjacent, Direction side) {
        return adjacent.is((Block)this) && (Boolean)adjacent.getValue((Property)INVISIBLE) == false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)REINFORCED) == false && super.canDropFromExplosion(state, level, pos, explosion);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return (Boolean)state.getValue((Property)REINFORCED) == false && super.canBeReplaced(state, context);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!((Boolean)state.getValue((Property)REINFORCED)).booleanValue()) {
            super.onBlockExploded(state, level, pos, explosion);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return (Boolean)state.getValue((Property)REINFORCED) == false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)REINFORCED) != false ? Float.MAX_VALUE : super.getExplosionResistance();
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float progress = super.getDestroyProgress(state, player, level, pos);
        if (((Boolean)state.getValue((Property)REINFORCED)).booleanValue()) {
            progress *= 0.1f;
        }
        return progress;
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getValue(LIGHT) != CSProperties.Light.DARK;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level instanceof ServerLevel) {
            return;
        }
        if (state.getValue(LIGHT) != CSProperties.Light.FAKE_LIGHT) {
            return;
        }
        level.getLightEngine().checkBlock(pos);
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getValue(LIGHT) == CSProperties.Light.DARK ? level.getMaxLightLevel() : 0;
    }

    public int getLightEmission(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        CSProperties.Light light = (CSProperties.Light)((Object)state.getValue(LIGHT));
        if (light == CSProperties.Light.FAKE_LIGHT) {
            return FMLLoader.getDist() == Dist.CLIENT ? 15 : 0;
        }
        if (light == CSProperties.Light.LIGHT) {
            return 15;
        }
        return 0;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context) != CollisionContext.empty() && ((CSProperties.Ghost)((Object)state.getValue(GHOST))).canCollide(entityCollisionContext)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        if (pathComputationType == PathComputationType.LAND) {
            return state.getValue(GHOST) != CSProperties.Ghost.ALLOW_ALL || state.getValue(GHOST) != CSProperties.Ghost.ALLOW_MONSTER || state.getValue(GHOST) != CSProperties.Ghost.ALLOW_ANIMAL;
        }
        return false;
    }

    public BlockState fromStack(LevelAccessor accessor, BlockPos pos, ItemStack stack) {
        BlockState state = accessor.getBlockState(pos);
        return this.fromStack(state, stack);
    }

    private BlockState fromStack(BlockState state, ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof CrystalixWand)) {
            return state;
        }
        Block block = state.getBlock();
        if (!(block instanceof CrystalixGlass)) {
            return state;
        }
        CrystalixGlass glass = (CrystalixGlass)block;
        state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)INVISIBLE, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.INVISIBLE)))).setValue((Property)SHADELESS, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.SHADELESS)))).setValue((Property)REINFORCED, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.REINFORCED)))).setValue((Property)WATERLOGGABLE, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.WATERLOGGABLE)))).setValue(LIGHT, (Comparable)((Object)Objects.requireNonNull((CSProperties.Light)stack.get(CSRegistry.LIGHT))))).setValue(GHOST, (Comparable)((Object)Objects.requireNonNull((CSProperties.Ghost)stack.get(CSRegistry.GHOST))));
        CSRegistry.Colors color = Objects.requireNonNull((CSRegistry.Colors)stack.get(CSRegistry.COLOR));
        if (!glass.color().equals(color) && stack.get(CSRegistry.APPLY_COLORLESS) == Boolean.FALSE) {
            DeferredHolder holder = (DeferredHolder)CSRegistry.ENTRIES.get((Object)this.type, (Object)color);
            if (holder == null) {
                return state;
            }
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((CrystalixGlass)((Object)holder.get())).defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)))).setValue((Property)WATERLOGGABLE, (Comparable)((Boolean)state.getValue((Property)WATERLOGGABLE)))).setValue((Property)INVISIBLE, (Comparable)((Boolean)state.getValue((Property)INVISIBLE)))).setValue((Property)SHADELESS, (Comparable)((Boolean)state.getValue((Property)SHADELESS)))).setValue((Property)REINFORCED, (Comparable)((Boolean)state.getValue((Property)REINFORCED)))).setValue(LIGHT, (Comparable)((Object)((CSProperties.Light)((Object)state.getValue(LIGHT)))))).setValue(GHOST, (Comparable)((Object)((CSProperties.Ghost)((Object)state.getValue(GHOST)))));
        }
        return state;
    }

    @Generated
    public CSRegistry.Types type() {
        return this.type;
    }

    @Generated
    public CSRegistry.Colors color() {
        return this.color;
    }
}

