/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.compat;

import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.client.lang.CSTranslatable;
import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.config.CSClientConfig;
import dev.satherov.crystalix.core.CSRegistry;
import dev.satherov.crystalix.core.annotations.NothingNull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
@NothingNull
public class CSJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation CRYSTALIX_BLOCK = ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"crystalix_block");

    private static Component getTranslation(CSLanguage language, boolean state) {
        return language.text(ChatFormatting.GRAY).append((Component)Component.literal((String)": ")).append((Component)(state ? CSLanguage.PROPERTY_ENABLED.text(ChatFormatting.DARK_GREEN) : CSLanguage.PROPERTY_DISABLED.text(ChatFormatting.DARK_RED)));
    }

    private static <T extends CSTranslatable> Component getTranslation(CSLanguage language, T state) {
        return language.text(ChatFormatting.GRAY).append((Component)Component.literal((String)": ")).append((Component)state.text());
    }

    private static Component getTranslation(CSLanguage language, MutableComponent component) {
        return language.text(ChatFormatting.GRAY).append((Component)Component.literal((String)": ")).append((Component)component);
    }

    private static void showTooltips(ITooltip tooltip, BlockAccessor accessor) {
        tooltip.add(CSJadePlugin.getTranslation(CSLanguage.PROPERTY_INVISIBLE, (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.INVISIBLE)));
        tooltip.add(CSJadePlugin.getTranslation(CSLanguage.PROPERTY_SHADELESS, (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.SHADELESS)));
        tooltip.add(CSJadePlugin.getTranslation(CSLanguage.PROPERTY_REINFORCED, (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.REINFORCED)));
        tooltip.add(CSJadePlugin.getTranslation(CSLanguage.PROPERTY_WATERLOGGABLE, (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.WATERLOGGABLE)));
        tooltip.add(CSJadePlugin.getTranslation(CSLanguage.PROPERTY_LIGHT, (CSProperties.Light)((Object)accessor.getBlockState().getValue(CrystalixGlass.LIGHT))));
        tooltip.add(CSJadePlugin.getTranslation(CSLanguage.PROPERTY_GHOST, (CSProperties.Ghost)((Object)accessor.getBlockState().getValue(CrystalixGlass.GHOST))));
        tooltip.add(CSJadePlugin.getTranslation(CSLanguage.PROPERTY_COLOR, CSRegistry.Colors.fromState(accessor.getBlockState()).text()));
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)CrystalixComponentProvider.INSTANCE, CrystalixGlass.class);
    }

    static enum CrystalixComponentProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            switch (CSClientConfig.getJadeMode()) {
                case ALWAYS: {
                    CSJadePlugin.showTooltips(tooltip, accessor);
                    break;
                }
                case WAND: {
                    if (!(accessor.getPlayer().getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof CrystalixWand) && !(accessor.getPlayer().getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof CrystalixWand)) break;
                    CSJadePlugin.showTooltips(tooltip, accessor);
                    break;
                }
            }
        }

        public ResourceLocation getUid() {
            return CRYSTALIX_BLOCK;
        }
    }
}

