/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.core.network;

import dev.satherov.crystalix.Crystalix;
import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSBooleanProperty;
import dev.satherov.crystalix.common.properties.CSEnumProperty;
import dev.satherov.crystalix.common.properties.CSProperties;
import lombok.Generated;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SwapPropertiesPayload(BlockState state) implements CustomPacketPayload
{
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwapPropertiesPayload.class);
    public static final StreamCodec<RegistryFriendlyByteBuf, SwapPropertiesPayload> STREAM_CODEC = CustomPacketPayload.codec(SwapPropertiesPayload::encode, SwapPropertiesPayload::new);
    public static final CustomPacketPayload.Type<SwapPropertiesPayload> TYPE = new CustomPacketPayload.Type(Crystalix.rl("swap_properties"));

    private SwapPropertiesPayload(RegistryFriendlyByteBuf buffer) {
        this(Block.stateById((int)buffer.readVarInt()));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeVarInt(Block.getId((BlockState)this.state));
    }

    public static void handle(SwapPropertiesPayload message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp;
            if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack wand = CrystalixWand.find((Player)player);
                if (wand.isEmpty()) {
                    return;
                }
                BlockState state = message.state();
                Block patt1$temp = state.getBlock();
                if (!(patt1$temp instanceof CrystalixGlass)) {
                    return;
                }
                CrystalixGlass glass = (CrystalixGlass)patt1$temp;
                CSProperties properties = CSProperties.of(wand);
                ((CSBooleanProperty)properties.properties().get(CSProperties.WATERLOGGABLE)).set((Boolean)state.getValue((Property)CrystalixGlass.WATERLOGGABLE));
                ((CSBooleanProperty)properties.properties().get(CSProperties.SHADELESS)).set((Boolean)state.getValue((Property)CrystalixGlass.SHADELESS));
                ((CSBooleanProperty)properties.properties().get(CSProperties.INVISIBLE)).set((Boolean)state.getValue((Property)CrystalixGlass.INVISIBLE));
                ((CSBooleanProperty)properties.properties().get(CSProperties.REINFORCED)).set((Boolean)state.getValue((Property)CrystalixGlass.REINFORCED));
                ((CSEnumProperty)properties.properties().get(CSProperties.LIGHT)).set((CSProperties.Light)((Object)state.getValue(CrystalixGlass.LIGHT)));
                ((CSEnumProperty)properties.properties().get(CSProperties.GHOST)).set((CSProperties.Ghost)((Object)state.getValue(CrystalixGlass.GHOST)));
                ((CSEnumProperty)properties.properties().get(CSProperties.COLOR)).set(glass.color());
                player.getInventory().setChanged();
            }
        }).exceptionally(e -> {
            log.error("Failed to pick wand properties from BlockState", e);
            return null;
        });
    }
}

