/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.fluids;

import alexthw.starbunclemania.common.block.fluids.LiquidJarTile;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidJarBlock
extends TickableModBlock {
    public static final VoxelShape shape = Stream.of(Block.box((double)3.0, (double)13.1, (double)3.0, (double)13.0, (double)15.1, (double)13.0), Block.box((double)6.0, (double)15.1, (double)6.0, (double)10.0, (double)16.1, (double)10.0), Block.box((double)3.0, (double)1.1, (double)3.0, (double)13.0, (double)11.1, (double)13.0), Block.box((double)4.0, (double)11.1, (double)4.0, (double)12.0, (double)13.1, (double)12.0), Stream.of(Block.box((double)1.9, (double)1.4, (double)1.9, (double)3.5, (double)11.0, (double)3.5), Block.box((double)1.9, (double)1.4, (double)12.5, (double)3.5, (double)11.0, (double)14.1), Block.box((double)1.9, (double)0.2, (double)1.9, (double)14.1, (double)1.4, (double)14.1), Block.box((double)12.5, (double)1.4, (double)12.5, (double)14.1, (double)11.0, (double)14.1), Block.box((double)12.5, (double)1.4, (double)1.9, (double)14.1, (double)11.0, (double)3.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public LiquidJarBlock() {
        super(LiquidJarBlock.defaultProperties().noOcclusion());
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return shape;
    }

    public boolean hasDynamicLightEmission(@NotNull BlockState state) {
        return true;
    }

    public int getLightEmission(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LiquidJarTile) {
            LiquidJarTile be = (LiquidJarTile)blockEntity;
            FluidTank tank = be.tank;
            if (!tank.isEmpty()) {
                return Math.round((float)tank.getFluid().getFluid().getFluidType().getLightLevel() * be.getFluidPercentage());
            }
        }
        return super.getLightEmission(state, level, pos);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        LiquidJarTile be;
        BlockEntity blockEntity;
        if (super.useItemOn(stack, state, level, pos, player, hand, hitResult) == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidJarTile && (be = (LiquidJarTile)blockEntity).interact(player, hand)) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, Level worldIn, @NotNull BlockPos pos) {
        LiquidJarTile tile = (LiquidJarTile)worldIn.getBlockEntity(pos);
        if (tile == null || tile.getFluidPercentage() <= 0.0f) {
            return 0;
        }
        return (int)(tile.getFluidPercentage() * 15.0f);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new LiquidJarTile(pPos, pState);
    }
}

