/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.item.cosmetic;

import alexthw.starbunclemania.client.BalloonRenderer;
import alexthw.starbunclemania.common.item.cosmetic.AbstractCosmeticItem;
import alexthw.starbunclemania.starbuncle.gas.StarbyGasBehavior;
import com.hollingsworth.arsnouveau.api.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarDrygmy;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StarBalloon
extends AbstractCosmeticItem
implements GeoItem,
IDyeable {
    static final Vec3 Translation = new Vec3(-0.1, 0.0, -0.05);
    static final Vec3 Scaling = new Vec3(1.0, 1.0, 1.0);
    public final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public StarBalloon(Item.Properties pProperties, String s) {
        super(pProperties, s);
    }

    public void onDye(ItemStack stack, DyeColor dyeColor) {
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(dyeColor.getTextureDiffuseColor(), false));
    }

    @Override
    public void changeBehavior(ItemStack stack, Player player, IDecoratable deco) {
        if (deco instanceof Starbuncle) {
            Starbuncle starby = (Starbuncle)deco;
            if (ModList.get().isLoaded("mekanism")) {
                starby.setBehavior((ChangeableBehavior)new StarbyGasBehavior(starby, new CompoundTag()));
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.starbuncle.gas_behavior_set"));
            }
        }
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            final BalloonRenderer renderer = new BalloonRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    public Vec3 getTranslations(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        Objects.requireNonNull(livingEntity);
        LivingEntity livingEntity2 = livingEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FamiliarWixie.class, FamiliarDrygmy.class, FamiliarBookwyrm.class}, (Object)livingEntity2, n)) {
            case 0 -> {
                FamiliarWixie ignored = (FamiliarWixie)livingEntity2;
                yield Vec3.ZERO;
            }
            case 1 -> {
                FamiliarDrygmy ignored = (FamiliarDrygmy)livingEntity2;
                yield Vec3.ZERO;
            }
            case 2 -> {
                FamiliarBookwyrm ignored = (FamiliarBookwyrm)livingEntity2;
                yield Vec3.ZERO;
            }
            default -> Translation;
        };
    }

    public Vec3 getScaling(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FamiliarWixie.class, FamiliarDrygmy.class, FamiliarBookwyrm.class}, (Object)livingEntity, n)) {
            case 0 -> {
                FamiliarWixie ignored = (FamiliarWixie)livingEntity;
                yield defaultScaling;
            }
            case 1 -> {
                FamiliarDrygmy ignored = (FamiliarDrygmy)livingEntity;
                yield defaultScaling;
            }
            case 2 -> {
                FamiliarBookwyrm ignored = (FamiliarBookwyrm)livingEntity;
                yield defaultScaling;
            }
            default -> Scaling;
        };
    }

    public ItemDisplayContext getTransformType() {
        return ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
    }

    public String getBone(LivingEntity entity) {
        return "body";
    }

    public boolean canWear(LivingEntity entity) {
        return entity instanceof Starbuncle || entity instanceof FamiliarEntity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController((GeoAnimatable)this, "idle_controller", 1, tAnimationEvent -> tAnimationEvent.setAndContinue(RawAnimation.begin().thenLoop("float"))));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

