/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.datagen;

import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancementBuilder;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancements;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class StarAdvancementsProvider
extends AdvancementProvider {
    public StarAdvancementsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new SBMAdvancements()));
    }

    public static class SBMAdvancements
    extends ANAdvancements {
        static Consumer<AdvancementHolder> advancementConsumer;

        static AdvancementHolder dummy(String name) {
            return new AdvancementHolder(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)name), new Advancement(Optional.empty(), Optional.empty(), AdvancementRewards.EMPTY, Map.of(), new AdvancementRequirements(List.of()), false));
        }

        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider registries, @NotNull Consumer<AdvancementHolder> con, @NotNull ExistingFileHelper existingFileHelper) {
            advancementConsumer = con;
            AdvancementHolder starbyCharm = SBMAdvancements.dummy("starby_charm");
            this.saveBasicItem((ItemLike)ModRegistry.STARBUCKET.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.STARBALLON.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.STARBATTERY.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.STARTRASH.get(), starbyCharm);
            this.saveBasicItem((ItemLike)ModRegistry.PROFHAT.get(), starbyCharm);
            AdvancementHolder starbyShades = SBMAdvancements.dummy("starbuncle_shades");
            this.saveBasicItem((ItemLike)ModRegistry.ROBINHAT.get(), starbyShades);
            AdvancementHolder jar = SBMAdvancements.dummy("source_jar");
            AdvancementHolder fluidJar = this.saveBasicItem((ItemLike)ModRegistry.FLUID_JAR.get(), jar);
            this.saveBasicItem((ItemLike)ModRegistry.SOURCE_CONDENSER.get(), fluidJar);
            this.saveBasicItem((ItemLike)ModRegistry.FLUID_SOURCELINK.get(), fluidJar);
            AdvancementHolder wixie = SBMAdvancements.dummy("wixie_charm");
            this.builder("wixie_cook").display((ItemLike)Blocks.FURNACE, AdvancementType.TASK, false).addCriterion(ANCriteriaTriggers.createCriterion(ModRegistry.WIXIE_1)).parent(wixie).save(con);
            this.builder("wixie_stoneworks").display((ItemLike)Blocks.STONECUTTER, AdvancementType.TASK, false).addCriterion(ANCriteriaTriggers.createCriterion(ModRegistry.WIXIE_2)).parent(wixie).save(con);
            this.builder("wixie_mixer").display((ItemLike)ModRegistry.MIXER_WIXIE_CAULDRON.get(), AdvancementType.TASK, false).addCriterion(ANCriteriaTriggers.createCriterion(ModRegistry.WIXIE_3)).parent(wixie).save(con);
        }

        public ANAdvancementBuilder buildBasicItem(ItemLike item, AdvancementHolder parent) {
            return this.builder(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath()).normalItemRequirement(item).parent(parent);
        }

        public AdvancementHolder saveBasicItem(ItemLike item, AdvancementHolder parent) {
            return this.buildBasicItem(item, parent).save(advancementConsumer);
        }

        public ANAdvancementBuilder builder(String key) {
            return ANAdvancementBuilder.builder((String)"starbunclemania", (String)key);
        }
    }
}

