/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.registry;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.client.FluidSourceLinkRenderer;
import alexthw.starbunclemania.client.SourceCondenserRenderer;
import alexthw.starbunclemania.common.StarbyMountEntity;
import alexthw.starbunclemania.common.block.BlockItemWTooltip;
import alexthw.starbunclemania.common.block.fluids.FluidSourcelinkBlock;
import alexthw.starbunclemania.common.block.fluids.FluidSourcelinkTile;
import alexthw.starbunclemania.common.block.fluids.LiquidJarBlock;
import alexthw.starbunclemania.common.block.fluids.LiquidJarTile;
import alexthw.starbunclemania.common.block.fluids.SourceCondenserBlock;
import alexthw.starbunclemania.common.block.fluids.SourceCondenserTile;
import alexthw.starbunclemania.common.block.wixie_stations.MixerWixieCauldron;
import alexthw.starbunclemania.common.block.wixie_stations.MixerWixieCauldronTile;
import alexthw.starbunclemania.common.block.wixie_stations.SmeltingWixieCauldron;
import alexthw.starbunclemania.common.block.wixie_stations.SmeltingWixieCauldronTile;
import alexthw.starbunclemania.common.block.wixie_stations.StonecutterWixieCauldron;
import alexthw.starbunclemania.common.block.wixie_stations.StonecutterWixieCauldronTile;
import alexthw.starbunclemania.common.data.DirectionData;
import alexthw.starbunclemania.common.data.FluidScrollData;
import alexthw.starbunclemania.common.item.DirectionScroll;
import alexthw.starbunclemania.common.item.FluidJarItem;
import alexthw.starbunclemania.common.item.FluidScroll;
import alexthw.starbunclemania.common.item.cosmetic.ArchitectHat;
import alexthw.starbunclemania.common.item.cosmetic.ChefHat;
import alexthw.starbunclemania.common.item.cosmetic.ExampleCosmetic;
import alexthw.starbunclemania.common.item.cosmetic.MinerHat;
import alexthw.starbunclemania.common.item.cosmetic.PlayerCurioCosmetic;
import alexthw.starbunclemania.common.item.cosmetic.ProfHat;
import alexthw.starbunclemania.common.item.cosmetic.RRobinHat;
import alexthw.starbunclemania.common.item.cosmetic.StarBalloon;
import alexthw.starbunclemania.common.item.cosmetic.StarBin;
import alexthw.starbunclemania.common.item.cosmetic.StarBucket;
import alexthw.starbunclemania.common.item.cosmetic.StarSword;
import alexthw.starbunclemania.common.item.cosmetic.StarWand;
import alexthw.starbunclemania.common.item.cosmetic.StarbAABattery;
import alexthw.starbunclemania.common.item.cosmetic.StarbySaddle;
import alexthw.starbunclemania.recipe.FluidSourcelinkRecipe;
import alexthw.starbunclemania.registry.EidolonCompat;
import alexthw.starbunclemania.registry.FarmerDelightCompat;
import alexthw.starbunclemania.registry.MekanismCompat;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.items.RendererBlockItem;
import com.hollingsworth.arsnouveau.common.items.summon_charms.StarbuncleCharm;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModRegistry {
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"starbunclemania");
    private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"starbunclemania");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"starbunclemania");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"starbunclemania");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"starbunclemania");
    public static final DeferredRegister<DataComponentType<?>> D_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"starbunclemania");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"starbunclemania");
    public static final DeferredRegister<CriterionTrigger<?>> TRIGGERS = DeferredRegister.create((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)"starbunclemania");
    public static final DeferredRegister<RecipeType<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"starbunclemania");
    public static final DeferredRegister<RecipeSerializer<?>> R_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"starbunclemania");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"starbunclemania");
    public static final TagKey<Fluid> POTION = FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"potion"));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<DirectionData>> DIRECTION = D_COMPONENTS.register("direction", () -> DataComponentType.builder().persistent(DirectionData.CODEC).networkSynchronized(DirectionData.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<FluidScrollData>> FLUID_SCROLL = D_COMPONENTS.register("fluid_scroll", () -> DataComponentType.builder().persistent(FluidScrollData.CODEC).networkSynchronized(FluidScrollData.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SimpleFluidContent>> FLUID_CONTENT = D_COMPONENTS.register("fluid_content", () -> DataComponentType.builder().persistent(SimpleFluidContent.CODEC).networkSynchronized(SimpleFluidContent.STREAM_CODEC).build());
    public static final DeferredHolder<RecipeType<?>, RecipeType<FluidSourcelinkRecipe>> FLUID_SOURCELINK_RT = RECIPES.register("fluid_sourcelink", () -> RecipeType.simple((ResourceLocation)StarbuncleMania.prefix("fluid_sourcelink")));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<FluidSourcelinkRecipe>> FLUID_SOURCELINK_RS = R_SERIALIZERS.register("fluid_sourcelink", FluidSourcelinkRecipe.Serializer::new);
    public static final DeferredHolder<Item, Item> DIRECTION_SCROLL;
    public static final DeferredHolder<Item, Item> FLUID_SCROLL_ALLOW;
    public static final DeferredHolder<Item, Item> FLUID_SCROLL_DENY;
    public static final DeferredHolder<Item, Item> STARHAT;
    public static final DeferredHolder<Item, Item> PROFHAT;
    public static final DeferredHolder<Item, Item> ROBINHAT;
    public static final DeferredHolder<Item, Item> STARBATTERY;
    public static final DeferredHolder<Item, Item> STARBUCKET;
    public static final DeferredHolder<Item, Item> STARBALLON;
    public static final DeferredHolder<Item, Item> STARTRASH;
    public static final DeferredHolder<Item, Item> STARSWORD;
    public static final DeferredHolder<Item, Item> STARWAND;
    public static final DeferredHolder<Item, Item> STARSADDLE;
    public static final DeferredHolder<Item, Item> STARMINE;
    public static final DeferredHolder<Item, Item> STARBUILD;
    public static final DeferredHolder<Item, Item> CHEF_HAT;
    public static final DeferredHolder<Item, ? extends PlayerCurioCosmetic> STARBY_EARS;
    public static final DeferredHolder<Item, ? extends PlayerCurioCosmetic> DRYGMY_HORNS;
    public static final DeferredHolder<Item, ? extends PlayerCurioCosmetic> ALAK_HAT;
    public static final DeferredHolder<Item, ? extends PlayerCurioCosmetic> SEA_BUNNY;
    public static final DeferredHolder<Item, ? extends PlayerCurioCosmetic> WHIRLI_PROP;
    public static final DeferredHolder<Block, Block> FLUID_JAR;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<LiquidJarTile>> FLUID_JAR_TILE;
    public static final DeferredHolder<Block, Block> SOURCE_CONDENSER;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<SourceCondenserTile>> SOURCE_CONDENSER_TILE;
    public static final DeferredHolder<Block, Block> FLUID_SOURCELINK;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FluidSourcelinkTile>> FLUID_SOURCELINK_TILE;
    public static final DeferredHolder<Block, Block> SMELTING_WIXIE_CAULDRON;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<SmeltingWixieCauldronTile>> SMELTING_WIXIE_CAULDRON_TILE;
    public static final DeferredHolder<Block, Block> STONEWORK_WIXIE_CAULDRON;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<StonecutterWixieCauldronTile>> STONECUTTER_WIXIE_CAULDRON_TILE;
    public static final DeferredHolder<Block, Block> MIXER_WIXIE_CAULDRON;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<MixerWixieCauldronTile>> MIXER_WIXIE_CAULDRON_TILE;
    public static final DeferredHolder<EntityType<?>, EntityType<StarbyMountEntity>> STARBY_MOUNT;
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> WIXIE_1;
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> WIXIE_2;
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> WIXIE_3;
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> SBM_TAB;

    public static void registerRegistries(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        FLUID_TYPES.register(bus);
        FLUIDS.register(bus);
        BLOCK_ENTITIES.register(bus);
        ENTITIES.register(bus);
        RECIPES.register(bus);
        R_SERIALIZERS.register(bus);
        TABS.register(bus);
        D_COMPONENTS.register(bus);
        TRIGGERS.register(bus);
        bus.addListener(ModRegistry::registerEntityAttributes);
        bus.addListener(ModRegistry::editEntityAttributes);
        if (ModList.get().isLoaded("mekanism")) {
            MekanismCompat.register(bus);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmerDelightCompat.register();
        }
        if (ModList.get().isLoaded("eidolon_repraised")) {
            EidolonCompat.register();
        }
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)STARBY_MOUNT.get(), Starbuncle.attributes().add(Attributes.MAX_HEALTH, 20.0).build());
    }

    public static void editEntityAttributes(EntityAttributeModificationEvent event) {
        event.add((EntityType)ModEntities.STARBUNCLE_TYPE.get(), Attributes.ATTACK_DAMAGE, 2.0);
        event.add((EntityType)ModEntities.STARBUNCLE_TYPE.get(), Attributes.FOLLOW_RANGE, 5.0);
    }

    static Item.Properties basicItemProperties() {
        return new Item.Properties();
    }

    static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> addEntity(String name, float width, float height, boolean fire, boolean noSave, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(32).sized(width, height);
            if (noSave) {
                builder.noSave();
            }
            if (fire) {
                builder.fireImmune();
            }
            return builder.build("starbunclemania:" + name);
        });
    }

    static {
        WIXIE_1 = TRIGGERS.register("wixie_cook", PlayerTrigger::new);
        WIXIE_2 = TRIGGERS.register("wixie_stone", PlayerTrigger::new);
        WIXIE_3 = TRIGGERS.register("wixie_mix", PlayerTrigger::new);
        STARBY_EARS = ITEMS.register("starby_ears", () -> new PlayerCurioCosmetic(ModRegistry.basicItemProperties()).withTooltip("starbunclemania.starby_ears.tooltip"));
        DRYGMY_HORNS = ITEMS.register("drygmy_horns", () -> new PlayerCurioCosmetic(ModRegistry.basicItemProperties()).withTooltip("starbunclemania.drygmy_horns.tooltip"));
        ALAK_HAT = ITEMS.register("alak_hat", () -> new PlayerCurioCosmetic(ModRegistry.basicItemProperties()).withTooltip("starbunclemania.alak_hat.tooltip"));
        SEA_BUNNY = ITEMS.register("sea_bunny", () -> new PlayerCurioCosmetic(ModRegistry.basicItemProperties()).withTooltip("starbunclemania.sea_bunny.tooltip"));
        WHIRLI_PROP = ITEMS.register("whirli_prop", () -> new PlayerCurioCosmetic(ModRegistry.basicItemProperties()).withTooltip("starbunclemania.whirli_prop.tooltip"));
        STARHAT = ITEMS.register("star_hat", () -> new ExampleCosmetic(ModRegistry.basicItemProperties(), "starbunclemania.simple_cosmetic.tooltip"));
        PROFHAT = ITEMS.register("wyrm_degree", () -> new ProfHat(ModRegistry.basicItemProperties(), "starbunclemania.degree_hat.tooltip"));
        ROBINHAT = ITEMS.register("robin_mask", () -> new RRobinHat(ModRegistry.basicItemProperties(), "starbunclemania.robin_mask.tooltip"));
        STARBATTERY = ITEMS.register("star_battery", () -> new StarbAABattery(ModRegistry.basicItemProperties(), "starbunclemania.battery.tooltip"));
        STARBUCKET = ITEMS.register("star_bucket", () -> new StarBucket(ModRegistry.basicItemProperties(), "starbunclemania.bucket.tooltip"));
        STARBALLON = ITEMS.register("star_balloon", () -> new StarBalloon(ModRegistry.basicItemProperties(), "starbunclemania.balloon.tooltip"));
        STARTRASH = ITEMS.register("star_bin", () -> new StarBin(ModRegistry.basicItemProperties(), "starbunclemania.trash_bin.tooltip"));
        STARSWORD = ITEMS.register("star_sword", () -> new StarSword(ModRegistry.basicItemProperties()));
        STARWAND = ITEMS.register("star_wand", () -> new StarWand(new Item.Properties()));
        STARMINE = ITEMS.register("star_miner", () -> new MinerHat(ModRegistry.basicItemProperties(), "starbunclemania.miner_hat.tooltip"));
        STARBUILD = ITEMS.register("star_build", () -> new ArchitectHat(ModRegistry.basicItemProperties(), "starbunclemania.builder_hat.tooltip"));
        CHEF_HAT = ITEMS.register("chef_hat", () -> new ChefHat(ModRegistry.basicItemProperties()).withTooltip("starbunclemania.chef_hat.tooltip"));
        DIRECTION_SCROLL = ITEMS.register("direction_scroll", () -> new DirectionScroll(ModRegistry.basicItemProperties()));
        FLUID_SCROLL_ALLOW = ITEMS.register("fluid_scroll_allow", () -> new FluidScroll(ModRegistry.basicItemProperties()));
        FLUID_SCROLL_DENY = ITEMS.register("fluid_scroll_deny", () -> new FluidScroll(ModRegistry.basicItemProperties()){

            @Override
            public boolean isDenied(ItemStack fluidScroll, FluidStack fluidInTank) {
                FluidScrollData filter = (FluidScrollData)fluidScroll.get(FLUID_SCROLL);
                if (filter == null) {
                    return false;
                }
                return filter.containsStack(fluidInTank);
            }
        });
        STARSADDLE = ITEMS.register("star_saddle", () -> new StarbySaddle(ModRegistry.basicItemProperties()));
        STARBY_MOUNT = ModRegistry.addEntity("starby_mount", 2.0f, 2.0f, true, false, StarbyMountEntity::new, MobCategory.CREATURE);
        FLUID_JAR = BLOCKS.register("fluid_jar", LiquidJarBlock::new);
        ITEMS.register("fluid_jar", () -> new FluidJarItem((Block)FLUID_JAR.get(), ModRegistry.basicItemProperties().stacksTo(1)));
        FLUID_JAR_TILE = BLOCK_ENTITIES.register("fluid_jar_tile", () -> BlockEntityType.Builder.of(LiquidJarTile::new, (Block[])new Block[]{(Block)FLUID_JAR.get()}).build(null));
        SOURCE_CONDENSER = BLOCKS.register("source_condenser", SourceCondenserBlock::new);
        SOURCE_CONDENSER_TILE = BLOCK_ENTITIES.register("source_condenser_tile", () -> BlockEntityType.Builder.of(SourceCondenserTile::new, (Block[])new Block[]{(Block)SOURCE_CONDENSER.get()}).build(null));
        ITEMS.register("source_condenser", () -> new RendererBlockItem((Block)SOURCE_CONDENSER.get(), ModRegistry.basicItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return SourceCondenserRenderer::getISTER;
            }
        });
        FLUID_SOURCELINK = BLOCKS.register("fluid_sourcelink", FluidSourcelinkBlock::new);
        FLUID_SOURCELINK_TILE = BLOCK_ENTITIES.register("fluid_sourcelink_tile", () -> BlockEntityType.Builder.of(FluidSourcelinkTile::new, (Block[])new Block[]{(Block)FLUID_SOURCELINK.get()}).build(null));
        ITEMS.register("fluid_sourcelink", () -> new RendererBlockItem((Block)FLUID_SOURCELINK.get(), ModRegistry.basicItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return FluidSourceLinkRenderer::getISTER;
            }
        });
        SMELTING_WIXIE_CAULDRON = BLOCKS.register("smelting_wixie_cauldron", SmeltingWixieCauldron::new);
        SMELTING_WIXIE_CAULDRON_TILE = BLOCK_ENTITIES.register("smelting_wixie_cauldron_tile", () -> BlockEntityType.Builder.of(SmeltingWixieCauldronTile::new, (Block[])new Block[]{(Block)SMELTING_WIXIE_CAULDRON.get()}).build(null));
        ITEMS.register("smelting_wixie_cauldron", () -> new BlockItemWTooltip((Block)SMELTING_WIXIE_CAULDRON.get(), ModRegistry.basicItemProperties(), "starbunclemania.wixie_cauldron.smelting.tooltip"));
        STONEWORK_WIXIE_CAULDRON = BLOCKS.register("stonecutting_wixie_cauldron", StonecutterWixieCauldron::new);
        STONECUTTER_WIXIE_CAULDRON_TILE = BLOCK_ENTITIES.register("stonecutting_wixie_cauldron_tile", () -> BlockEntityType.Builder.of(StonecutterWixieCauldronTile::new, (Block[])new Block[]{(Block)STONEWORK_WIXIE_CAULDRON.get()}).build(null));
        ITEMS.register("stonecutting_wixie_cauldron", () -> new BlockItemWTooltip((Block)STONEWORK_WIXIE_CAULDRON.get(), ModRegistry.basicItemProperties(), "starbunclemania.wixie_cauldron.stonecutting.tooltip"));
        MIXER_WIXIE_CAULDRON = BLOCKS.register("mixer_wixie_cauldron", MixerWixieCauldron::new);
        MIXER_WIXIE_CAULDRON_TILE = BLOCK_ENTITIES.register("mixer_wixie_cauldron_tile", () -> BlockEntityType.Builder.of(MixerWixieCauldronTile::new, (Block[])new Block[]{(Block)MIXER_WIXIE_CAULDRON.get()}).build(null));
        ITEMS.register("mixer_wixie_cauldron", () -> new BlockItemWTooltip((Block)MIXER_WIXIE_CAULDRON.get(), ModRegistry.basicItemProperties(), "starbunclemania.wixie_cauldron.mixer.tooltip"));
        SBM_TAB = TABS.register("general", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.starbunclemania")).icon(() -> ((StarbuncleCharm)((StarbuncleCharm)ItemsRegistry.STARBUNCLE_CHARM.get())).getDefaultInstance()).displayItems((params, output) -> {
            for (DeferredHolder entry : ITEMS.getEntries()) {
                output.accept(((Item)entry.get()).getDefaultInstance());
            }
        }).withTabsBefore(new ResourceLocation[]{CreativeTabRegistry.BLOCKS.getKey().location()}).build());
    }
}

