/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.energy;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.starbuncle.StarHelper;
import alexthw.starbunclemania.starbuncle.energy.EnergyExtractGoal;
import alexthw.starbunclemania.starbuncle.energy.EnergyStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class StarbyEnergyBehavior
extends StarbyListBehavior {
    public static final ResourceLocation TRANSPORT_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"starby_energy_transport");
    private int energy = 0;

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public StarbyEnergyBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.contains("battery")) {
            this.energy = tag.getInt("battery");
        }
        this.goals.add(new WrappedGoal(3, (Goal)new EnergyExtractGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new EnergyStoreGoal(entity, this)));
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || (this.getBatteryForTake() == null || this.energy > (Integer)Configs.STARBATTERY_THRESHOLD.get()) && (this.energy == 0 || this.getBatteryForStore() == null);
    }

    @Nullable
    public static IEnergyStorage getHandlerFromCap(BlockPos pos, Level level, Direction side) {
        if (side == null) {
            side = Direction.UP;
        }
        side = StarHelper.checkItemFramesForSide(pos, level, side);
        return (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)side);
    }

    public IEnergyStorage getHandlerFromCap(BlockPos pos, Direction side) {
        return StarbyEnergyBehavior.getHandlerFromCap(pos, this.level, side);
    }

    @Nullable
    public BlockPos getBatteryForTake() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.level.isLoaded(pos) || !this.isPositionValidTake(pos)) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public BlockPos getBatteryForStore() {
        for (BlockPos pos : this.TO_LIST) {
            if (!this.level.isLoaded(pos) || !this.isPositionValidStore(pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null) {
            return false;
        }
        IEnergyStorage battery = this.getHandlerFromCap(p, (Direction)this.FROM_DIRECTION_MAP.get(p.hashCode()));
        if (battery != null) {
            return battery.canExtract() && battery.getEnergyStored() >= 0;
        }
        return false;
    }

    public boolean isPositionValidStore(BlockPos p) {
        if (p == null) {
            return false;
        }
        IEnergyStorage battery = this.getHandlerFromCap(p, (Direction)this.TO_DIRECTION_MAP.get(p.hashCode()));
        if (battery != null) {
            return battery.canReceive() && battery.receiveEnergy(this.getRatio(), true) >= (Integer)Configs.STARBATTERY_THRESHOLD.get();
        }
        return false;
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null) {
            BlockEntity be = this.level.getBlockEntity(storedPos);
            if (this.level.getCapability(Capabilities.EnergyStorage.BLOCK, storedPos, (Object)side) != null || this.getHandlerFromCap(storedPos, side) != null) {
                this.addToPos(storedPos);
                this.syncTag();
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.energy_to"));
            }
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && (this.starbuncle.level().getCapability(Capabilities.EnergyStorage.BLOCK, storedPos, (Object)side) != null || this.getHandlerFromCap(storedPos, side) != null)) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.energy_from"));
        }
    }

    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.storing_energy", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.taking_energy", (Object[])new Object[]{this.FROM_LIST.size()}));
    }

    public CompoundTag toTag(CompoundTag tag) {
        tag.putInt("battery", this.energy);
        return super.toTag(tag);
    }

    public int getRatio() {
        return (Integer)Configs.STARBATTERY_RATIO.get();
    }

    public ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public ItemStack getStackForRender() {
        return ItemStack.EMPTY;
    }
}

