/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.trash;

import alexthw.starbunclemania.starbuncle.trash.StarbyVoidBehavior;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class VoidFromStorageGoal
extends GoToPosGoal<StarbyVoidBehavior> {
    public VoidFromStorageGoal(Starbuncle starbuncle, StarbyVoidBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> starbuncle.getHeldStack().isEmpty());
    }

    public boolean canUse() {
        boolean superCan = super.canUse();
        if (!superCan || ((StarbyVoidBehavior)this.behavior).FROM_LIST.isEmpty()) {
            return false;
        }
        if (this.getDestination() == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoTakeDestination", "No valid take destination"));
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(20));
            return false;
        }
        if (((StarbyVoidBehavior)this.behavior).isBedPowered()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("BedPowered", "Bed Powered, cannot take items"));
            return false;
        }
        return true;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !((StarbyVoidBehavior)this.behavior).isBedPowered();
    }

    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyVoidBehavior)this.behavior).isPositionValidTake(pos);
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyVoidBehavior)this.behavior).getValidTakePos();
    }

    public boolean onDestinationReached() {
        Level world = this.starbuncle.level();
        BlockEntity tileEntity = world.getBlockEntity(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("TakePosBroken", "Take Tile Broken"));
            return true;
        }
        IItemHandler iItemHandler = ((StarbyVoidBehavior)this.behavior).getItemCapFromTile(this.targetPos, (Direction)((StarbyVoidBehavior)this.behavior).FROM_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return true;
        }
        for (int j = 0; j < iItemHandler.getSlots() && this.starbuncle.getHeldStack().isEmpty(); ++j) {
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.isEmpty()) continue;
            int count = 64;
            this.starbuncle.setHeldStack(iItemHandler.extractItem(j, Math.min(count, stack.getMaxStackSize()), false));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("SetHeld", "Taking " + count + "x " + this.starbuncle.getHeldStack().getHoverName().getString() + " from " + this.targetPos.toString()));
            this.starbuncle.level().playSound(null, this.starbuncle.getX(), this.starbuncle.getY(), this.starbuncle.getZ(), SoundEvents.ITEM_PICKUP, this.starbuncle.getSoundSource(), 1.0f, 1.0f);
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)world;
            try {
                OpenChestEvent event = new OpenChestEvent(serverLevel, this.targetPos, 20);
                event.open();
                EventQueue.getServerInstance().addEvent((ITimedEvent)event);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.starbuncle.getHeldStack().isEmpty()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("TakeFromChest", "No items to take? Cancelling goal."));
        }
        return true;
    }
}

