/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.blocks.base;

import com.glodblock.github.modularbees.common.items.ItemMBBlock;
import com.glodblock.github.modularbees.dynamic.DyDataPack;
import com.glodblock.github.modularbees.dynamic.DyResourcePack;
import com.glodblock.github.modularbees.util.DataProvider;
import com.glodblock.github.modularbees.util.MBTags;
import com.glodblock.github.modularbees.util.RegisterTask;
import com.glodblock.github.modularbees.util.ResourceProvider;
import com.glodblock.github.modularbees.util.RotorBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockMBBase
extends Block
implements RegisterTask,
ResourceProvider,
DataProvider {
    private ResourceLocation registryName;

    public BlockMBBase(BlockBehaviour.Properties properties) {
        super(properties);
        if (!this.getRotorStrategy().isNone()) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getRotorStrategy().property(), (Comparable)this.getRotorStrategy().defaultFace()));
        }
    }

    @NotNull
    public String toString() {
        String regName = this.getRegistryName() != null ? this.getRegistryName().getPath() : "unregistered";
        return this.getClass().getSimpleName() + "[" + regName + "]";
    }

    public RotorBlocks getRotorStrategy() {
        return RotorBlocks.NONE;
    }

    public Item createItem() {
        return new ItemMBBlock(this, new Item.Properties());
    }

    @NotNull
    public final Direction[] getValidFaces() {
        return this.getRotorStrategy().isNone() ? new Direction[]{} : this.getRotorStrategy().faces();
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        if (!this.getRotorStrategy().isNone()) {
            builder.add(new Property[]{this.getRotorStrategy().property()});
        }
    }

    @Nullable
    public TagKey<Block> harvestTool() {
        return null;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack heldItem, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player p, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (heldItem.is(MBTags.WRENCH) && !this.getRotorStrategy().isNone()) {
            Direction newFacing;
            Direction direction = newFacing = p.isShiftKeyDown() ? hit.getDirection().getOpposite() : hit.getDirection();
            if (this.getRotorStrategy().validFace(newFacing)) {
                this.setFacing(state, newFacing, level, pos);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public Direction getFacing(BlockState state) {
        if (!this.getRotorStrategy().isNone()) {
            return (Direction)state.getValue((Property)this.getRotorStrategy().property());
        }
        return null;
    }

    public void setFacing(BlockState state, Direction facing, Level world, BlockPos pos) {
        if (this.getRotorStrategy().validFace(facing)) {
            BlockState newState = (BlockState)state.setValue((Property)this.getRotorStrategy().property(), (Comparable)facing);
            world.setBlockAndUpdate(pos, newState);
            this.onFacingChange(facing, world, pos);
        }
    }

    protected void onFacingChange(Direction facing, Level world, BlockPos pos) {
    }

    @Override
    public void onRegister(ResourceLocation id) {
        this.registryName = id;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public static BlockBehaviour.Properties hive() {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).strength(2.2f).mapColor(MapColor.WOOD).sound(SoundType.WOOD);
    }

    public static BlockBehaviour.Properties centrifuge() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(2.5f);
    }

    @Override
    public void load(DyDataPack pack) {
        this.loadLootTable(pack);
    }

    protected void loadLootTable(DyDataPack pack) {
        pack.addBlockLootTable(this.registryName, (JsonElement)this.createSingleBlockLootJson(this.registryName));
    }

    @Override
    public void load(DyResourcePack pack) {
        this.loadBlockState(pack);
        this.loadBlockModel(pack);
        this.loadBlockItemModel(pack);
    }

    protected void loadBlockState(DyResourcePack pack) {
        pack.addBlockState(this.registryName, (JsonElement)this.createStateJson(this.registryName));
    }

    protected void loadBlockModel(DyResourcePack pack) {
        pack.addBlockModel(this.registryName, (JsonElement)this.createFullCubeModelJson(this.registryName));
    }

    protected void loadBlockItemModel(DyResourcePack pack) {
        pack.addItemModel(this.registryName, (JsonElement)this.createItemModelJson(this.registryName));
    }

    protected JsonObject createSingleBlockLootJson(ResourceLocation id) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:block");
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        pool.addProperty("bonus_rolls", (Number)0.0);
        JsonObject condition = new JsonObject();
        condition.addProperty("condition", "minecraft:survives_explosion");
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)condition);
        pool.add("conditions", (JsonElement)conditions);
        JsonObject entry = new JsonObject();
        entry.addProperty("type", "minecraft:item");
        entry.addProperty("name", id.toString());
        JsonArray entries = new JsonArray();
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        pool.addProperty("rolls", (Number)1.0);
        pools.add((JsonElement)pool);
        root.add("pools", (JsonElement)pools);
        root.addProperty("random_sequence", this.addPrefix(id));
        return root;
    }

    protected JsonObject createFullCubeModelJson(ResourceLocation id) {
        JsonObject texture = new JsonObject();
        texture.addProperty("all", this.addPrefix(id));
        JsonObject root = new JsonObject();
        root.add("textures", (JsonElement)texture);
        root.addProperty("parent", "minecraft:block/cube_all");
        return root;
    }

    protected JsonObject createStateJson(ResourceLocation id) {
        JsonObject variants = new JsonObject();
        for (Direction face : this.getValidFaces()) {
            JsonObject sub = new JsonObject();
            sub.addProperty("model", this.addPrefix(id));
            switch (face) {
                case UP: {
                    this.modifyModel(270, 0, sub);
                    break;
                }
                case DOWN: {
                    this.modifyModel(90, 0, sub);
                    break;
                }
                case NORTH: {
                    this.modifyModel(0, 0, sub);
                    break;
                }
                case SOUTH: {
                    this.modifyModel(0, 180, sub);
                    break;
                }
                case EAST: {
                    this.modifyModel(0, 90, sub);
                    break;
                }
                case WEST: {
                    this.modifyModel(0, 270, sub);
                }
            }
            variants.add("facing=" + face.getName(), (JsonElement)sub);
        }
        if (this.getValidFaces().length == 0) {
            JsonObject sub = new JsonObject();
            sub.addProperty("model", this.addPrefix(id));
            variants.add("", (JsonElement)sub);
        }
        JsonObject root = new JsonObject();
        root.add("variants", (JsonElement)variants);
        return root;
    }

    protected void modifyModel(int x, int y, JsonObject json) {
        if (x != 0) {
            json.addProperty("x", (Number)x);
        }
        if (y != 0) {
            json.addProperty("y", (Number)y);
        }
    }

    protected String addPrefix(ResourceLocation id) {
        String[] s = id.toString().split(":");
        return s[0] + ":block/" + s[1];
    }

    protected JsonObject createItemModelJson(ResourceLocation id) {
        JsonObject parent = new JsonObject();
        parent.addProperty("parent", this.addPrefix(id));
        return parent;
    }
}

