/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.base;

import com.glodblock.github.modularbees.common.MBConfig;
import com.glodblock.github.modularbees.common.caps.EnergyHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBEnergyInventory;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import com.glodblock.github.modularbees.common.recipe.ElectrodeRecipe;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularComponent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileMBOverclocker
extends TileMBModularComponent
implements ItemHandlerHost,
EnergyHandlerHost,
SlotListener {
    public static final int POWER_USE = (Integer)MBConfig.OVERCLOCKER_POWER_USAGE.get();
    protected final MBItemInventory electrode = new MBItemInventory(this, 1).setSlotLimit(1).setFilter(this::isElectrode).inputOnly();
    protected final MBEnergyInventory energy = new MBEnergyInventory(this, 2000000).inputOnly();
    private ElectrodeRecipe running = null;
    private boolean stuck = false;

    public TileMBOverclocker(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public float getBoostAndConsume(int bees) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ItemStack stack;
            ServerLevel server = (ServerLevel)level;
            if (this.isActive() && bees > 0 && !(stack = this.electrode.getStackInSlot(0)).isEmpty()) {
                int power;
                float boost;
                if (this.running == null) {
                    this.running = this.findRecipe(stack);
                }
                if (this.running != null && (boost = this.running.power() - 1.0f) > 0.0f && this.energy.getEnergyStored() >= bees * POWER_USE && (power = this.energy.forceExtractEnergy(bees * POWER_USE, false)) >= bees * POWER_USE) {
                    stack.hurtAndBreak(this.damage(bees), server, null, item -> this.electrode.setStackInSlot(0, ItemStack.EMPTY));
                    return boost;
                }
            }
        }
        return 0.0f;
    }

    private int damage(int base) {
        float a = (float)base / 15.0f + 1.0f;
        float e = (float)Math.pow(1.03, base);
        return (int)(a * e);
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("electrode", (Tag)this.electrode.serializeNBT(provider));
        data.put("energy", (Tag)this.energy.serializeNBT(provider));
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.electrode.deserializeNBT(provider, data.getCompound("electrode"));
        this.energy.deserializeNBT(provider, (Tag)data.getCompound("energy"));
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.electrode;
    }

    public MBEnergyInventory getEnergyStorage() {
        return this.energy;
    }

    public MBEnergyInventory getEnergyStorage(Direction side) {
        if (side == null) {
            return this.getEnergyStorage();
        }
        if (side == this.getFacing()) {
            return this.energy;
        }
        return null;
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return this.electrode;
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.electrode.toList());
    }

    public abstract Direction getFacing();

    public abstract Component getDisplayName();

    @Nullable
    private ElectrodeRecipe findRecipe(ItemStack stack) {
        if (this.stuck || this.level == null) {
            return null;
        }
        return ElectrodeRecipe.getCache(this.level).get(stack.getItem());
    }

    private boolean isElectrode(ItemStack stack) {
        if (this.level == null) {
            return false;
        }
        return ElectrodeRecipe.getCache(this.level).containsKey(stack.getItem());
    }

    @Override
    public void onChange(IItemHandler inv, int slot) {
        if (inv == this.electrode) {
            this.stuck = false;
            this.running = null;
        }
    }
}

