/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.inventory.container;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integratedcrafting.RegistryEntries;
import org.cyclops.integratedcrafting.core.part.PartTypeInterfaceCraftingBase;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerPartInterfaceCraftingSettings
extends ContainerPartSettings {
    private final int lastChannelInterfaceCraftingValueId = this.getNextValueId();
    private final Map<IngredientComponent<?, ?>, Integer> targetSideOverrideValueIds = Maps.newIdentityHashMap();
    private final int lastDisableCraftingCheckValueId;
    private final int lastBlockingModeValueId;

    public ContainerPartInterfaceCraftingSettings(int id, Inventory playerInventory, RegistryFriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleContainer(0), PartHelpers.readPartTarget((RegistryFriendlyByteBuf)packetBuffer), Optional.empty(), PartHelpers.readPart((FriendlyByteBuf)packetBuffer));
    }

    public ContainerPartInterfaceCraftingSettings(int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, IPartType partType) {
        super((MenuType)RegistryEntries.CONTAINER_INTERFACE_CRAFTING_SETTINGS.get(), id, playerInventory, inventory, target, partContainer, partType);
        for (ResourceLocation key : Sets.newTreeSet((Iterable)IngredientComponent.REGISTRY.keySet())) {
            IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.get(key);
            this.targetSideOverrideValueIds.put(ingredientComponent, this.getNextValueId());
        }
        this.lastDisableCraftingCheckValueId = this.getNextValueId();
        this.lastBlockingModeValueId = this.getNextValueId();
    }

    protected int getPlayerInventoryOffsetY() {
        return 174;
    }

    protected void initializeValues() {
        super.initializeValues();
        PartTypeInterfaceCraftingBase.State partState = (PartTypeInterfaceCraftingBase.State)this.getPartState();
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastChannelInterfaceCraftingValueId, (int)partState.getChannelCrafting());
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.stream().toList()) {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.getTargetSideOverrideValueId(ingredientComponent), (int)partState.getIngredientComponentTargetSideOverride(ingredientComponent).ordinal());
        }
        if (partState instanceof PartTypeInterfaceCrafting.State) {
            PartTypeInterfaceCrafting.State stateNormal = (PartTypeInterfaceCrafting.State)partState;
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisableCraftingCheckValueId, (boolean)stateNormal.isDisableCraftingCheck());
        }
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastBlockingModeValueId, (boolean)partState.getCraftingJobHandler().isBlockingJobsMode());
    }

    public int getLastChannelInterfaceCraftingValueId() {
        return this.lastChannelInterfaceCraftingValueId;
    }

    public int getLastChannelInterfaceValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastChannelInterfaceCraftingValueId);
    }

    public int getTargetSideOverrideValueId(IngredientComponent<?, ?> ingredientComponent) {
        return this.targetSideOverrideValueIds.get(ingredientComponent);
    }

    @Nullable
    public Direction getTargetSideOverrideValue(IngredientComponent<?, ?> ingredientComponent) {
        int i = ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.getTargetSideOverrideValueId(ingredientComponent));
        if (i < 0) {
            return this.getTarget().getTarget().getSide();
        }
        return Direction.values()[i];
    }

    public int getLastDisableCraftingCheckValueId() {
        return this.lastDisableCraftingCheckValueId;
    }

    public int getLastBlockingModeValueId() {
        return this.lastBlockingModeValueId;
    }

    public boolean getLastDisableCraftingCheckValue() {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.lastDisableCraftingCheckValueId);
    }

    public boolean getLastBlockingModeValue() {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.lastBlockingModeValueId);
    }

    public void setLastDisableCraftingCheckValue(boolean value) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisableCraftingCheckValueId, (boolean)value);
    }

    public void setLastBlockingModeValue(boolean value) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastBlockingModeValueId, (boolean)value);
    }

    protected void updatePartSettings() {
        super.updatePartSettings();
        PartTypeInterfaceCraftingBase.State partState = (PartTypeInterfaceCraftingBase.State)this.getPartState();
        partState.setChannelCrafting(this.getLastChannelInterfaceValue());
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.stream().toList()) {
            partState.setIngredientComponentTargetSideOverride(ingredientComponent, this.getTargetSideOverrideValue(ingredientComponent));
        }
        if (partState instanceof PartTypeInterfaceCrafting.State) {
            PartTypeInterfaceCrafting.State stateNormal = (PartTypeInterfaceCrafting.State)partState;
            stateNormal.setDisableCraftingCheck(this.getLastDisableCraftingCheckValue());
        }
        if (partState.getCraftingJobHandler().setBlockingJobsMode(this.getLastBlockingModeValue())) {
            partState.sendUpdate();
            partState.onDirty();
        }
    }
}

