/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.ICondition;

public record StackWithChance(TagOutput stack, float chance, List<ICondition> conditions) {
    public static final DualCodec<RegistryFriendlyByteBuf, StackWithChance> CODECS = DualCompositeCodecs.composite((DualMapCodec)TagOutput.CODECS.fieldOf("output"), StackWithChance::stack, (DualMapCodec)DualCodecs.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)), StackWithChance::chance, (DualMapCodec)IEDualCodecs.CONDITIONS.optionalFieldOf("conditions", List.of()), StackWithChance::conditions, StackWithChance::new);
    public static final Codec<StackWithChance> OPTIONAL_BASIC_CODEC = Codec.either((Codec)CODECS.codec(), (Codec)TagOutput.CODECS.codec()).xmap(either -> (StackWithChance)either.map((Function)Functions.identity(), tagOutput -> new StackWithChance((TagOutput)tagOutput, 1.0f, new ICondition[0])), stack -> stack.conditions().isEmpty() && stack.chance() >= 1.0f ? Either.right((Object)stack.stack()) : Either.left((Object)stack));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<StackWithChance>> STREAM_LIST = CODECS.streamCodec().apply(ByteBufCodecs.list());

    public StackWithChance {
        Preconditions.checkNotNull((Object)stack);
    }

    public StackWithChance(ItemStack stack, float chance) {
        this(new TagOutput(stack), chance, List.of());
    }

    public StackWithChance(TagOutput stack, float chance, ICondition ... conditions) {
        this(stack, chance, Arrays.asList(conditions));
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("stack", this.stack.get().save(provider));
        compoundNBT.putFloat("chance", this.chance);
        return compoundNBT;
    }

    public static StackWithChance readFromNBT(HolderLookup.Provider provider, CompoundTag compoundNBT) {
        Preconditions.checkNotNull((Object)compoundNBT);
        Preconditions.checkArgument((boolean)compoundNBT.contains("chance"));
        Preconditions.checkArgument((boolean)compoundNBT.contains("stack"));
        ItemStack stack = (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundNBT.getCompound("stack")).orElseThrow();
        float chance = compoundNBT.getFloat("chance");
        return new StackWithChance(stack, chance);
    }

    public StackWithChance recalculate(double totalChance) {
        return new StackWithChance(this.stack, (float)((double)this.chance / totalChance), this.conditions);
    }
}

