/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.utils.Color4;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public final class TransformingVertexBuilder
extends VertexConsumerWrapper {
    private final PoseStack transform;
    private Vec2 globalUv = null;
    private Vec2i globalOverlay = null;
    private Vec2i globalLightmap = null;
    private Vector3f globalNormal = null;
    private Color4 globalColor = null;

    public TransformingVertexBuilder(VertexConsumer base, PoseStack transform) {
        super(base);
        this.transform = transform;
    }

    public TransformingVertexBuilder(VertexConsumer base) {
        this(base, new PoseStack());
    }

    public TransformingVertexBuilder(MultiBufferSource buffer, RenderType type, PoseStack transform) {
        this(buffer.getBuffer(type), transform);
    }

    public TransformingVertexBuilder(MultiBufferSource buffer, RenderType type) {
        this(buffer, type, new PoseStack());
    }

    @Nonnull
    public VertexConsumer addVertex(float x, float y, float z) {
        Vector4f pos = new Vector4f(x, y, z, 1.0f);
        pos.mul((Matrix4fc)this.transform.last().pose());
        super.addVertex(pos.x, pos.y, pos.z);
        if (this.globalUv != null) {
            this.setUv(this.globalUv.x, this.globalUv.y);
        }
        if (this.globalOverlay != null) {
            this.setUv1(this.globalOverlay.x, this.globalOverlay.y);
        }
        if (this.globalLightmap != null) {
            this.setUv2(this.globalLightmap.x, this.globalLightmap.y);
        }
        if (this.globalNormal != null) {
            this.setNormal(this.globalNormal.x, this.globalNormal.y, this.globalNormal.z);
        }
        if (this.globalColor != null) {
            this.setColor(this.globalColor.r(), this.globalColor.g(), this.globalColor.b(), this.globalColor.a());
        }
        return this;
    }

    @Nonnull
    public VertexConsumer setNormal(float x, float y, float z) {
        Vector3f normal = new Vector3f(x, y, z);
        normal.mul((Matrix3fc)this.transform.last().normal());
        return super.setNormal(normal.x, normal.y, normal.z);
    }

    public void defaultColor(float r, float g, float b, float a) {
        this.globalColor = new Color4(r, g, b, a);
    }

    public void unsetDefaultColor() {
        this.globalColor = null;
    }

    public void setUV(Vec2 uv) {
        this.globalUv = uv;
    }

    public void setDefaultLight(int light) {
        this.globalLightmap = new Vec2i(light & 0xFF, light >> 16);
    }

    public void setDefaultNormal(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z);
        vec.normalize();
        this.globalNormal = vec;
    }

    public void setDefaultOverlay(int packedOverlayIn) {
        this.globalOverlay = new Vec2i(packedOverlayIn & 0xFFFF, packedOverlayIn >> 16);
    }

    private record Vec2i(int x, int y) {
    }
}

