/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneTimerBlockEntity
extends ConnectorRedstoneBlockEntity {
    public static final int TIMER_MIN = 8;
    public static final int TIMER_MAX = 200;
    public int timerSetting = 80;
    int currentTimer = 0;
    public boolean requireControlSignal = false;
    boolean hasControlSignal = false;
    public DyeColor redstoneChannelControl = DyeColor.WHITE;
    private static final Pair<DyeColor, Byte>[] NO_OVERRIDE = new Pair[0];
    private static final Map<Direction, VoxelShape> SHAPES = (Map)Util.make(new EnumMap(Direction.class), map -> {
        double wMin = 0.25;
        double wMax = 0.75;
        map.put(Direction.NORTH, Shapes.box((double)0.25, (double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)0.5));
        map.put(Direction.SOUTH, Shapes.box((double)0.25, (double)0.0, (double)0.5, (double)0.75, (double)1.0, (double)1.0));
        map.put(Direction.WEST, Shapes.box((double)0.0, (double)0.0, (double)0.25, (double)0.5, (double)1.0, (double)0.75));
        map.put(Direction.EAST, Shapes.box((double)0.5, (double)0.0, (double)0.25, (double)1.0, (double)1.0, (double)0.75));
        map.put(Direction.DOWN, Shapes.box((double)0.25, (double)0.0, (double)0.0, (double)0.75, (double)0.5, (double)1.0));
        map.put(Direction.UP, Shapes.box((double)0.25, (double)0.5, (double)0.0, (double)0.75, (double)1.0, (double)1.0));
    });

    public RedstoneTimerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ConnectorRedstoneBlockEntity>)((BlockEntityType)IEBlockEntities.REDSTONE_TIMER.get()), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.currentTimer > 0 && this.output > 0) {
            this.setOutput(0);
        }
        if (++this.currentTimer >= this.timerSetting) {
            this.setOutput(this.isActive() ? 15 : 0);
            this.resetTimer();
        }
        super.tickServer();
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.level.isClientSide && SafeChunkUtils.isChunkSafe((LevelAccessor)this.level, this.worldPosition)) {
            boolean hadSignal = this.hasControlSignal;
            boolean bl = this.hasControlSignal = handler.getValue(this.redstoneChannelControl.getId()) > 0;
            if (this.hasControlSignal && !hadSignal) {
                this.resetTimer();
            }
        }
    }

    private boolean isActive() {
        return !this.requireControlSignal || this.hasControlSignal;
    }

    private void resetTimer() {
        if (this.isActive()) {
            this.currentTimer = 0;
        }
    }

    private void setOutput(int value) {
        if (this.output != value) {
            this.output = value;
            this.rsDirty = true;
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        signals[this.redstoneChannel.ordinal()] = (byte)this.output;
        this.rsDirty = false;
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.level.isClientSide) {
            ImmersiveEngineering.proxy.openTileScreen("redstonetimer", this);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("timerSetting")) {
            this.timerSetting = message.getInt("timerSetting");
        }
        if (message.contains("redstoneChannel")) {
            this.redstoneChannel = DyeColor.byId((int)message.getInt("redstoneChannel"));
        }
        if (message.contains("redstoneChannelControl")) {
            this.redstoneChannelControl = DyeColor.byId((int)message.getInt("redstoneChannelControl"));
        }
        if (message.contains("requireControlSignal")) {
            this.requireControlSignal = message.getBoolean("requireControlSignal");
        }
        this.updateAfterConfigure();
    }

    @Override
    protected void updateAfterConfigure() {
        this.resetTimer();
        super.updateAfterConfigure();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        nbt.putInt("timerSetting", this.timerSetting);
        nbt.putInt("currentTimer", this.currentTimer);
        nbt.putBoolean("requireControlSignal", this.requireControlSignal);
        nbt.putBoolean("hasControlSignal", this.hasControlSignal);
        nbt.putInt("redstoneChannelControl", this.redstoneChannelControl.getId());
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        this.timerSetting = nbt.getInt("timerSetting");
        this.currentTimer = nbt.getInt("currentTimer");
        this.requireControlSignal = nbt.getBoolean("requireControlSignal");
        this.hasControlSignal = nbt.getBoolean("hasControlSignal");
        this.redstoneChannelControl = DyeColor.byId((int)nbt.getInt("redstoneChannelControl"));
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double conRadius = type.getRenderDiameter() / 2.0;
        return switch (side) {
            case Direction.UP -> new Vec3(0.5, 0.375 - conRadius, 0.1875 - conRadius);
            case Direction.DOWN -> new Vec3(0.5, 0.625 - conRadius, 0.8125 - conRadius);
            default -> new Vec3(0.5 - (double)side.getStepX() * (0.125 - conRadius), 0.1875 - conRadius, 0.5 - (double)side.getStepZ() * (0.125 - conRadius));
        };
    }

    @Override
    public boolean isRSInput() {
        return false;
    }

    @Override
    public boolean isRSOutput() {
        return false;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return false;
    }

    @Override
    public Pair<DyeColor, Byte>[] overrideVoltmeterRead() {
        return NO_OVERRIDE;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.getFacing());
    }

    @Override
    public Component[] getOverlayText(@Nullable BlockState blockState, Player player, HitResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return null;
        }
        return new Component[]{RedstoneTimerBlockEntity.getTimeFormatted(this.timerSetting), RedstoneTimerBlockEntity.getChannelComponent("_output", this.redstoneChannel)};
    }

    public static Component getTimeFormatted(int ticks) {
        if (ticks < 20) {
            return Component.translatable((String)"desc.immersiveengineering.info.ticks", (Object[])new Object[]{ticks});
        }
        double seconds = (double)ticks / 20.0;
        DecimalFormat format = new DecimalFormat("0.00");
        return Component.translatable((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{format.format(seconds)});
    }
}

