/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractShapedRecipe;
import javax.annotation.Nullable;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class BasicShapedRecipe
extends AbstractShapedRecipe<MatchLocation> {
    public BasicShapedRecipe(ShapedRecipe vanillaBase) {
        super(vanillaBase);
    }

    protected boolean checkMatch(CraftingInput craftingInventory, MatchLocation loc) {
        for (int invX = 0; invX < craftingInventory.width(); ++invX) {
            for (int invY = 0; invY < craftingInventory.height(); ++invY) {
                int recX = invX - loc.xOffset;
                int recY = invY - loc.yOffset;
                Ingredient expectedContent = Ingredient.EMPTY;
                if (recX >= 0 && recY >= 0 && recX < this.getWidth() && recY < this.getHeight()) {
                    int recipeSlot = loc.mirrored ? this.getWidth() - recX - 1 + recY * this.getWidth() : recX + recY * this.getWidth();
                    expectedContent = (Ingredient)this.getIngredients().get(recipeSlot);
                }
                if (expectedContent.test(craftingInventory.getItem(invX + invY * craftingInventory.width()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public MatchLocation findMatch(CraftingInput inv) {
        for (int xOffset = 0; xOffset <= inv.width() - this.getWidth(); ++xOffset) {
            for (int yOffset = 0; yOffset <= inv.height() - this.getHeight(); ++yOffset) {
                for (boolean mirror : AbstractFluidAwareRecipe.BOOLEANS) {
                    MatchLocation loc = new MatchLocation(xOffset, yOffset, mirror, this.getWidth());
                    if (!this.checkMatch(inv, loc)) continue;
                    return loc;
                }
            }
        }
        return null;
    }

    public static class MatchLocation
    implements AbstractFluidAwareRecipe.IMatchLocation {
        private final int xOffset;
        private final int yOffset;
        private final boolean mirrored;
        private final int recipeWidth;

        private MatchLocation(int x, int y, boolean mirrored, int recipeWidth) {
            this.xOffset = x;
            this.yOffset = y;
            this.mirrored = mirrored;
            this.recipeWidth = recipeWidth;
        }

        @Override
        public int getListIndex(int x, int y) {
            int localX = x - this.xOffset;
            int localY = y - this.yOffset;
            if (this.mirrored) {
                return this.recipeWidth - localX - 1 + localY * this.recipeWidth;
            }
            return localX + localY * this.recipeWidth;
        }
    }
}

