/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.ToolboxHandler;
import blusunrize.immersiveengineering.common.blocks.metal.ToolboxBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import java.util.Objects;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ToolboxMenu
extends IEContainerMenu
implements IESlot.ICallbackContainer {
    protected int blockedSlot = -1;

    public static ToolboxMenu makeFromBE(MenuType<?> type, int id, Inventory invPlayer, ToolboxBlockEntity be) {
        return new ToolboxMenu(ToolboxMenu.blockCtx(type, id, be), invPlayer, (IItemHandler)new ItemStackHandler(be.getInventory()));
    }

    public static ToolboxMenu makeFromItem(MenuType<?> type, int id, Inventory invPlayer, EquipmentSlot slot, ItemStack stack) {
        return new ToolboxMenu(ToolboxMenu.itemCtx(type, id, invPlayer, slot, stack), invPlayer, Objects.requireNonNull((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM))).setBlockedSlot(invPlayer);
    }

    public static ToolboxMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new ToolboxMenu(ToolboxMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(23));
    }

    public static ToolboxMenu makeClientItem(MenuType<?> type, int id, Inventory invPlayer) {
        return new ToolboxMenu(ToolboxMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(23)).setBlockedSlot(invPlayer);
    }

    public ToolboxMenu setBlockedSlot(Inventory invPlayer) {
        this.blockedSlot = invPlayer.selected + 27 + 23;
        return this;
    }

    public ToolboxMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv) {
        super(ctx);
        int i;
        int j;
        this.ownSlotCount = 0;
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 48, 24));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 30, 42));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 48, 42));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 75, 24));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 93, 24));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 111, 24));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 75, 42));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 93, 42));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 111, 42));
        this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 129, 42));
        for (j = 0; j < 6; ++j) {
            this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 35 + j * 18, 77));
        }
        for (j = 0; j < 7; ++j) {
            this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, this.ownSlotCount++, 26 + j * 18, 112));
        }
        for (i = 0; i < 3; ++i) {
            for (int j2 = 0; j2 < 9; ++j2) {
                this.addSlot(new Slot((Container)inventoryPlayer, j2 + i * 9 + 9, 8 + j2 * 18, 157 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 215));
        }
    }

    @Override
    public boolean canInsert(ItemStack stack, int slotNumber, Slot slotObject) {
        return ToolboxMenu.canInsert(stack, slotNumber);
    }

    public static boolean canInsert(ItemStack stack, int slotNumber) {
        if (stack.isEmpty()) {
            return false;
        }
        if (!IEApi.isAllowedInCrate(stack)) {
            return false;
        }
        if (slotNumber < 3) {
            return ToolboxHandler.isFood(stack);
        }
        if (slotNumber < 10) {
            return ToolboxHandler.isTool(stack);
        }
        if (slotNumber < 16) {
            return ToolboxHandler.isWiring(stack);
        }
        return true;
    }

    @Override
    public void clicked(int par1, int par2, ClickType par3, Player par4EntityPlayer) {
        if (this.blockedSlot >= 0 && (par1 == this.blockedSlot || par3 == ClickType.SWAP && par2 == par4EntityPlayer.getInventory().selected)) {
            return;
        }
        super.clicked(par1, par2, par3, par4EntityPlayer);
    }

    @Override
    public boolean canTake(ItemStack stack, int slotNumer, Slot slotObject) {
        return true;
    }
}

