/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class IETools {
    public static Supplier<ShovelItem> createShovel(Tier tier) {
        return () -> new ShovelItem(tier, IETools.toolProperties(tier, 1.5, -3.0));
    }

    public static Supplier<AxeItem> createAxe(Tier tier) {
        return () -> new AxeItem(tier, IETools.toolProperties(tier, 6.0, -3.1));
    }

    public static Supplier<PickaxeItem> createPickaxe(Tier tier) {
        return () -> new PickaxeItem(tier, IETools.toolProperties(tier, 1.0, -2.8));
    }

    public static Supplier<SwordItem> createSword(Tier tier) {
        return () -> new SwordItem(tier, IETools.toolProperties(tier, 3.0, -2.4));
    }

    public static Supplier<HoeItem> createHoe(Tier tier) {
        return () -> new HoeItem(tier, IETools.toolProperties(tier, -2.0, -1.0));
    }

    private static Item.Properties toolProperties(Tier tier, double attackDamage, double attackSpeed) {
        return new Item.Properties().stacksTo(1).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, attackDamage + (double)tier.getAttackDamageBonus(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build());
    }
}

