/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.items.JerrycanItem;
import blusunrize.immersiveengineering.common.items.PotionBucketItem;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="immersiveengineering")
public class ItemCapabilityRegistration {
    @SubscribeEvent
    public static void registerBlockCapabilities(RegisterCapabilitiesEvent event) {
        ItemCapabilityRegistration.registerCapacitorCapabilities(event, IEBlocks.MetalDevices.CAPACITOR_LV, IEServerConfig.MACHINES.lvCapConfig);
        ItemCapabilityRegistration.registerCapacitorCapabilities(event, IEBlocks.MetalDevices.CAPACITOR_MV, IEServerConfig.MACHINES.mvCapConfig);
        ItemCapabilityRegistration.registerCapacitorCapabilities(event, IEBlocks.MetalDevices.CAPACITOR_HV, IEServerConfig.MACHINES.hvCapConfig);
        DieselToolItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Tools.DRILL));
        DieselToolItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Tools.BUZZSAW));
        IEShieldItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Misc.SHIELD));
        JerrycanItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Misc.JERRYCAN));
        PotionBucketItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Misc.POTION_BUCKET));
        PowerpackItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Misc.POWERPACK));
        RailgunItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Weapons.RAILGUN));
        RevolverItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Weapons.REVOLVER));
        ChemthrowerItem.registerCapabilities(ItemCapabilityRegistration.forType(event, IEItems.Weapons.CHEMTHROWER));
        InternalStorageItem.registerCapabilitiesISI(ItemCapabilityRegistration.forType(event, IEItems.Tools.TOOLBOX));
        InternalStorageItem.registerCapabilitiesISI(ItemCapabilityRegistration.forType(event, IEItems.Weapons.SPEEDLOADER));
        InternalStorageItem.registerCapabilitiesISI(ItemCapabilityRegistration.forType(event, IEItems.Misc.SKYHOOK));
        IEFluids.registerBucketCapabilities(event);
    }

    private static void registerCapacitorCapabilities(RegisterCapabilitiesEvent ev, Supplier<? extends ItemLike> capItem, IEServerConfig.Machines.CapacitorConfig config) {
        ev.registerItem(Capabilities.EnergyStorage.ITEM, (stack, $) -> new ComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType)IEDataComponents.GENERIC_ENERGY.get(), config.storage.getAsInt()), new ItemLike[]{capItem.get()});
    }

    private static ItemCapabilityRegistrar forType(final RegisterCapabilitiesEvent ev, final Supplier<? extends ItemLike> type) {
        return new ItemCapabilityRegistrar(){

            @Override
            public <C, T> void register(ItemCapability<T, C> capability, ICapabilityProvider<ItemStack, C, T> provider) {
                ev.registerItem(capability, provider, new ItemLike[]{(ItemLike)type.get()});
            }
        };
    }

    public static interface ItemCapabilityRegistrar {
        public <C, T> void register(ItemCapability<T, C> var1, ICapabilityProvider<ItemStack, C, T> var2);

        default public <T> void register(ItemCapability<T, Void> capability, Function<ItemStack, T> provider) {
            this.register(capability, (stack, $) -> provider.apply((ItemStack)stack));
        }
    }
}

